/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.aggregate;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroupSortSpec;
import org.iplass.mtp.entity.query.value.primary.EntityField;

public class WithinGroup
implements ASTNode {
    private static final long serialVersionUID = -4852397116891135710L;
    private List<WithinGroupSortSpec> sortSpecList = new ArrayList<WithinGroupSortSpec>();

    public List<WithinGroupSortSpec> getSortSpecList() {
        return this.sortSpecList;
    }

    public void setSortSpecList(List<WithinGroupSortSpec> sortSpecList) {
        this.sortSpecList = sortSpecList;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this) && this.sortSpecList != null) {
            for (WithinGroupSortSpec s : this.sortSpecList) {
                s.accept(visitor);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("within group(order by ");
        if (this.sortSpecList != null) {
            for (int i = 0; i < this.sortSpecList.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.sortSpecList.get(i));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sortSpecList == null ? 0 : this.sortSpecList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WithinGroup other = (WithinGroup)obj;
        return !(this.sortSpecList == null ? other.sortSpecList != null : !this.sortSpecList.equals(other.sortSpecList));
    }

    public WithinGroup add(WithinGroupSortSpec sortSpec) {
        if (sortSpec == null) {
            throw new NullPointerException("sortSpec is null");
        }
        if (this.sortSpecList == null) {
            this.sortSpecList = new ArrayList<WithinGroupSortSpec>();
        }
        this.sortSpecList.add(sortSpec);
        return this;
    }

    public WithinGroup add(Object value, SortSpec.SortType type) {
        return this.add(value, type, null);
    }

    public WithinGroup add(Object value, SortSpec.SortType type, SortSpec.NullOrderingSpec nullOrderingSpec) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.sortSpecList == null) {
            this.sortSpecList = new ArrayList<WithinGroupSortSpec>();
        }
        ValueExpression v = null;
        if (value instanceof ValueExpression) {
            v = (ValueExpression)value;
        } else if (value instanceof String) {
            v = new EntityField((String)value);
        } else {
            throw new QueryException("value is ValueExpression or String type required.");
        }
        return this.add(new WithinGroupSortSpec(v, type, nullOrderingSpec));
    }
}

