/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.primary;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.PrimaryValue;

public class EntityField
extends PrimaryValue {
    private static final long serialVersionUID = -1271662342712631753L;
    private String propertyName;

    public EntityField() {
    }

    public EntityField(String propertyName) {
        this.propertyName = propertyName;
        this.checkValidPropertyName();
    }

    private void checkValidPropertyName() {
        if (this.propertyName != null && this.propertyName.length() > 0) {
            char c = this.propertyName.charAt(0);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '_')) {
                throw new QueryException(this.propertyName + " is not valid EntityField.");
            }
            for (int i = 1; i < this.propertyName.length(); ++i) {
                c = this.propertyName.charAt(i);
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '_') continue;
                throw new QueryException(this.propertyName + " is not valid EntityField.");
            }
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        this.checkValidPropertyName();
    }

    @Override
    public String toString() {
        return this.propertyName;
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public int unnestCount() {
        if (this.propertyName != null) {
            for (int i = 0; i < this.propertyName.length(); ++i) {
                if (this.propertyName.charAt(i) == '.') continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityField other = (EntityField)obj;
        return !(this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName));
    }
}

