/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb;

import java.util.HashMap;
import org.iplass.mtp.impl.async.rdb.Queue;
import org.iplass.mtp.impl.async.rdb.Worker;
import org.iplass.mtp.impl.async.rdb.WorkerConfig;
import org.iplass.mtp.impl.async.rdb.WorkerFactory;
import org.iplass.mtp.impl.async.rdb.workers.ProcessWorker;
import org.iplass.mtp.impl.async.rdb.workers.RemoteWorker;
import org.iplass.mtp.impl.async.rdb.workers.ThreadWorker;
import org.iplass.mtp.impl.core.config.ServerEnv;

public class DefaultWorkerFactory
extends WorkerFactory {
    private final HashMap<String, int[]> myWorkers = this.parseServerProperty();
    private final boolean isWorkerProcess;

    public DefaultWorkerFactory() {
        String flg = System.getProperty("mtp.async.rdb.worker.process", "false");
        this.isWorkerProcess = Boolean.valueOf(flg);
    }

    private HashMap<String, int[]> parseServerProperty() {
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        String def = ServerEnv.getInstance().getProperty("mtp.async.rdb.workers");
        if (def != null) {
            String[] qAndIds;
            for (String qi : qAndIds = def.split(",")) {
                String[] qiSplit = qi.trim().split(":");
                int[] ids = new int[qiSplit.length - 1];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = Integer.parseInt(qiSplit[i + 1].trim());
                }
                map.put(qiSplit[0], ids);
            }
        }
        return map;
    }

    @Override
    public Worker createWorker(Queue queue, int workerId) {
        if (this.isWorkerProcess()) {
            return new RemoteWorker();
        }
        WorkerConfig wc = queue.getConfig().getWorker();
        if (wc.isLocal()) {
            if (wc.isNewProcessPerTask()) {
                return new ProcessWorker(queue, workerId);
            }
            return new ThreadWorker(queue, workerId);
        }
        int[] idList = this.getMyWorkers().get(queue.getName());
        if (idList != null) {
            for (int id : idList) {
                if (id != workerId) continue;
                if (wc.isNewProcessPerTask()) {
                    return new ProcessWorker(queue, workerId);
                }
                return new ThreadWorker(queue, workerId);
            }
        }
        return new RemoteWorker();
    }

    public boolean isWorkerProcess() {
        return this.isWorkerProcess;
    }

    public HashMap<String, int[]> getMyWorkers() {
        return this.myWorkers;
    }
}

