/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.async.rdb.DefaultWorkerFactory;
import org.iplass.mtp.impl.async.rdb.Queue;
import org.iplass.mtp.impl.async.rdb.QueueConfig;
import org.iplass.mtp.impl.async.rdb.TaskDao;
import org.iplass.mtp.impl.async.rdb.WorkerFactory;
import org.iplass.mtp.impl.counter.CounterService;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbQueueService
implements Service {
    public static final String DEFAULT_QUEUE_NAME = "default";
    private static Logger logger = LoggerFactory.getLogger(RdbQueueService.class);
    private List<QueueConfig> queue;
    private HashMap<String, Queue> queueMap;
    private HashMap<Integer, Queue> queueIdMap;
    private Queue defaultQueue;
    private CounterService taskIdCounter;
    private CounterService taskIdCounterForGroup;
    private RdbAdapter rdb;
    private boolean useQueue = false;
    private boolean cleanupHistoryOnInit = false;
    private int historyHoldDay = 1;

    public int getHistoryHoldDay() {
        return this.historyHoldDay;
    }

    public boolean isCleanupHistoryOnInit() {
        return this.cleanupHistoryOnInit;
    }

    public boolean isUseQueue() {
        return this.useQueue;
    }

    @Override
    public void init(Config config) {
        if (config.getValue("useQueue") != null) {
            this.useQueue = Boolean.valueOf(config.getValue("useQueue"));
        }
        this.rdb = config.getDependentService(RdbAdapterService.class).getRdbAdapter();
        this.taskIdCounter = (CounterService)config.getDependentService("TaskIdCounter");
        this.taskIdCounterForGroup = (CounterService)config.getDependentService("TaskIdCounterGrouping");
        if (config.getValue("cleanupHistoryOnInit") != null) {
            this.cleanupHistoryOnInit = Boolean.valueOf(config.getValue("cleanupHistoryOnInit"));
        }
        if (config.getValue("historyHoldDay") != null) {
            this.historyHoldDay = Integer.parseInt(config.getValue("historyHoldDay"));
        }
        this.queue = config.getValues("queue", QueueConfig.class);
        WorkerFactory workerFactory = config.getValue("workerFactory", WorkerFactory.class, new DefaultWorkerFactory());
        this.queueMap = new HashMap();
        this.queueIdMap = new HashMap();
        if (this.queue != null) {
            for (QueueConfig qc : this.queue) {
                Queue q = new Queue(qc, this.taskIdCounter, this.taskIdCounterForGroup, this.rdb, workerFactory);
                this.queueMap.put(q.getName(), q);
                this.queueIdMap.put(qc.getId(), q);
                if (!q.getName().equalsIgnoreCase(DEFAULT_QUEUE_NAME)) continue;
                this.defaultQueue = q;
            }
        }
        if (this.useQueue) {
            if (logger.isDebugEnabled()) {
                logger.debug("RdbQueueService initialize process started.init queues...");
            }
            if (this.defaultQueue == null) {
                throw new ServiceConfigrationException("default queue(named 'default') is not specified");
            }
            if (this.cleanupHistoryOnInit) {
                logger.debug("RdbQueueService.cleanupHistoryOnInit is true so start cleanup process start.");
                Transaction.required(t -> {
                    this.moveNoGetResultTaskToHistory();
                    this.deleteHistoryByDate(null);
                });
            }
            for (Queue q : this.queueMap.values()) {
                q.startWorker();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("RdbQueueService.useQueue flag is false.so not start RdbQueueService.");
        }
    }

    @Override
    public void destroy() {
        if (this.useQueue && this.queueMap != null) {
            logger.info("stopping queue worker...");
            for (Map.Entry<String, Queue> e : this.queueMap.entrySet()) {
                e.getValue().stopWorker();
                logger.debug("stopped worker of queue:" + e.getValue().getName());
            }
            logger.info("stopping queue worker...done.");
        }
    }

    public Queue getQueue(String queueName) {
        if (!this.useQueue) {
            throw new ServiceConfigrationException("RdbQueueService.useQueue=false. set to true if use RdbQueueService.");
        }
        if (queueName == null) {
            return this.defaultQueue;
        }
        return this.queueMap.get(queueName);
    }

    public Queue getQueueById(int id) {
        if (!this.useQueue) {
            throw new ServiceConfigrationException("RdbQueueService.useQueue=false. set to true if use RdbQueueService.");
        }
        return this.queueIdMap.get(id);
    }

    public List<String> getQueueNameList() {
        ArrayList<String> queueNameList = new ArrayList<String>();
        if (this.queue != null) {
            for (QueueConfig q : this.queue) {
                queueNameList.add(q.getName());
            }
        }
        return queueNameList;
    }

    public void deleteHistoryByDate(Timestamp date) {
        this.deleteHistoryByDate(date, false);
    }

    public void deleteHistoryByDate(Timestamp date, boolean isDirectTenant) {
        if (date == null) {
            date = new Timestamp(System.currentTimeMillis() - (long)(this.historyHoldDay * 24 * 60 * 60 * 1000));
        }
        new TaskDao(this.rdb).deleteHistoryByDate(date, isDirectTenant);
    }

    public void moveNoGetResultTaskToHistory() {
        if (this.queueMap != null) {
            for (Queue e : this.queueMap.values()) {
                e.moveNoGetResultTaskToHistory();
            }
        }
    }
}

