/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.impl.async.rdb.Task;
import org.iplass.mtp.impl.async.rdb.TaskSearchCondition;
import org.iplass.mtp.impl.async.rdb.sql.TaskQueueDeleteSql;
import org.iplass.mtp.impl.async.rdb.sql.TaskQueueInsertSql;
import org.iplass.mtp.impl.async.rdb.sql.TaskQueueSearchSql;
import org.iplass.mtp.impl.async.rdb.sql.TaskQueueUpdateSql;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;

public class TaskDao {
    private RdbAdapter rdb;
    private TaskQueueDeleteSql deleteSql;
    private TaskQueueInsertSql insertSql;
    private TaskQueueSearchSql searchSql;
    private TaskQueueUpdateSql updateSql;

    public TaskDao(RdbAdapter rdb) {
        this.rdb = rdb;
        this.deleteSql = rdb.getUpdateSqlCreator(TaskQueueDeleteSql.class);
        this.insertSql = rdb.getUpdateSqlCreator(TaskQueueInsertSql.class);
        this.searchSql = rdb.getQuerySqlCreator(TaskQueueSearchSql.class);
        this.updateSql = rdb.getUpdateSqlCreator(TaskQueueUpdateSql.class);
    }

    public Task load(final int tenantId, final int queueId, final long taskId, final boolean withBinary, final boolean withHistory, final boolean withLock) {
        SqlExecuter<Task> exec = new SqlExecuter<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Task logic() throws SQLException {
                String sql = TaskDao.this.searchSql.toLoadSql(tenantId, queueId, taskId, withBinary, withHistory, withLock, TaskDao.this.rdb);
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    if (rs.next()) {
                        Task task;
                        Task task2 = task = TaskDao.this.searchSql.toTask(TaskDao.this.rdb, rs, withBinary);
                        return task2;
                    }
                }
                return null;
            }
        };
        return (Task)exec.execute(this.rdb, true);
    }

    public void insert(final Task task) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                String sql = TaskDao.this.insertSql.toInsertSql(TaskDao.this.rdb);
                PreparedStatement ps = this.getPreparedStatement(sql);
                TaskDao.this.insertSql.setStoreParameter(task, TaskDao.this.rdb, ps);
                ps.executeUpdate();
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    public List<Task> searchForPoll(final int queueId, final int[] workerIds, final long currentTimeMillis, final String serverId, final int maxRetryCount) {
        SqlExecuter<List<Task>> exec = new SqlExecuter<List<Task>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Task> logic() throws SQLException {
                String sql = TaskDao.this.searchSql.toForPollSql(queueId, workerIds, currentTimeMillis, serverId, maxRetryCount, TaskDao.this.rdb);
                ArrayList<Task> list = new ArrayList<Task>();
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    while (rs.next()) {
                        list.add(TaskDao.this.searchSql.toTask(TaskDao.this.rdb, rs, false));
                    }
                }
                return list;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    public int countPreExecuting(final int tenantId, final int queueId, final String groupingKey, final long taskId, final String serverId) {
        SqlExecuter<Integer> exec = new SqlExecuter<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer logic() throws SQLException {
                String sql = TaskDao.this.searchSql.toCountPreExecutingSql(tenantId, queueId, groupingKey, taskId, serverId, TaskDao.this.rdb);
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    rs.next();
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
        };
        return (Integer)exec.execute(this.rdb, true);
    }

    public void update(final Task t) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                String sql = TaskDao.this.updateSql.toUpdateSql(TaskDao.this.rdb);
                PreparedStatement ps = this.getPreparedStatement(sql);
                TaskDao.this.updateSql.setStoreParameter(t, TaskDao.this.rdb, ps);
                int count = ps.executeUpdate();
                if (count < 1) {
                    throw new EntityConcurrentUpdateException(TaskDao.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                }
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    public void moveToHistory(final Task task, final TaskStatus toStatus) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                String copySql = TaskDao.this.insertSql.toCopySql(TaskDao.this.rdb);
                PreparedStatement ps = this.getPreparedStatement(copySql);
                TaskDao.this.insertSql.setStoreParameterForCopy(task, toStatus, TaskDao.this.rdb, ps);
                int count = ps.executeUpdate();
                if (count < 1) {
                    throw new EntityConcurrentUpdateException(TaskDao.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                }
                ps.close();
                String delSql = TaskDao.this.deleteSql.toDeleteSql(TaskDao.this.rdb);
                ps = this.getPreparedStatement(delSql);
                TaskDao.this.deleteSql.setDelParameter(task, TaskDao.this.rdb, ps);
                count = ps.executeUpdate();
                if (count < 1) {
                    throw new EntityConcurrentUpdateException(TaskDao.resourceString("impl.datastore.schemalessrdb.strategy.SLREntityStoreStrategy.alreadyOperated", new Object[0]));
                }
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    public List<Task> search(final TaskSearchCondition cond) {
        SqlExecuter<List<Task>> exec = new SqlExecuter<List<Task>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Task> logic() throws SQLException {
                String sql = TaskDao.this.searchSql.toSearchSql(cond, TaskDao.this.rdb);
                ArrayList<Task> list = new ArrayList<Task>();
                try (ResultSet rs = this.getStatement().executeQuery(sql);){
                    while (rs.next()) {
                        list.add(TaskDao.this.searchSql.toTask(TaskDao.this.rdb, rs, false));
                    }
                }
                return list;
            }
        };
        return (List)exec.execute(this.rdb, true);
    }

    public void deleteHistoryByDate(final Timestamp date, final boolean isDirectTenant) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                String delSql = TaskDao.this.deleteSql.toDeleteByDateSql(TaskDao.this.rdb, isDirectTenant);
                PreparedStatement ps = this.getPreparedStatement(delSql);
                TaskDao.this.deleteSql.setDelParameterForDate(date, TaskDao.this.rdb, ps, isDirectTenant);
                ps.executeUpdate();
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    public void delete(final Task task) {
        SqlExecuter<Void> exec = new SqlExecuter<Void>(){

            @Override
            public Void logic() throws SQLException {
                String delSql = TaskDao.this.deleteSql.toDeleteSql(TaskDao.this.rdb);
                PreparedStatement ps = this.getPreparedStatement(delSql);
                TaskDao.this.deleteSql.setDelParameter(task, TaskDao.this.rdb, ps);
                ps.executeUpdate();
                return null;
            }
        };
        exec.execute(this.rdb, true);
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

