/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.iplass.mtp.impl.async.rdb.Task;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class TaskQueueDeleteSql
extends UpdateSqlHandler {
    public String toDeleteSql(RdbAdapter rdb) {
        return "DELETE FROM TASK_QUEUE WHERE TENANT_ID=? AND Q_ID=? AND TASK_ID=? AND VER=?";
    }

    public void setDelParameter(Task task, RdbAdapter rdb, PreparedStatement ps) throws SQLException {
        int num = 1;
        ps.setInt(num++, task.getTenantId());
        ps.setInt(num++, task.getQueueId());
        ps.setLong(num++, task.getTaskId());
        ps.setLong(num++, task.getVersion());
    }

    public String toDeleteByDateSql(RdbAdapter rdb, boolean isDirectTenant) {
        String sql = "DELETE FROM TASK_QUEUE_HI WHERE UP_DATE<?";
        if (isDirectTenant) {
            sql = sql + " AND " + "TENANT_ID" + "=?";
        }
        return sql;
    }

    public void setDelParameterForDate(Timestamp date, RdbAdapter rdb, PreparedStatement ps, boolean isDirectTenant) throws SQLException {
        ps.setTimestamp(1, date, rdb.rdbCalendar());
        if (isDirectTenant) {
            int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
            ps.setInt(2, tenantId);
        }
    }
}

