/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb.sql;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.iplass.mtp.impl.async.rdb.Task;
import org.iplass.mtp.impl.async.rdb.sql.TaskQueueInsertSql;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class TaskQueueUpdateSql
extends UpdateSqlHandler {
    public String toUpdateSql(RdbAdapter rdb) {
        return "UPDATE TASK_QUEUE SET V_TIME=?,STATUS=?,RE_CNT=?,VER=VER+1,UP_DATE=" + rdb.systimestamp() + "," + "RES" + "=? WHERE " + "TENANT_ID" + "=? AND " + "Q_ID" + "=? AND " + "TASK_ID" + "=? AND " + "VER" + "=?";
    }

    public void setStoreParameter(Task task, RdbAdapter rdb, PreparedStatement ps) throws SQLException {
        int num = 1;
        ps.setLong(num++, task.getVisibleTime());
        ps.setString(num++, TaskQueueInsertSql.toStatusStr(task.getStatus()));
        ps.setInt(num++, task.getRetryCount());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(bos));){
            oos.writeObject(task.getResult());
            oos.flush();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        ps.setBinaryStream(num++, new ByteArrayInputStream(bos.toByteArray()));
        ps.setInt(num++, task.getTenantId());
        ps.setInt(num++, task.getQueueId());
        ps.setLong(num++, task.getTaskId());
        ps.setLong(num++, task.getVersion());
    }
}

