/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb.workers;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.impl.async.rdb.Queue;
import org.iplass.mtp.impl.async.rdb.Task;
import org.iplass.mtp.impl.async.rdb.workers.LocalWorker;
import org.iplass.mtp.impl.async.rdb.workers.WorkerCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadWorker
extends LocalWorker {
    private static Logger logger = LoggerFactory.getLogger(ThreadWorker.class);
    private ExecutorService executor;

    public ThreadWorker(Queue queue, int workerId) {
        super(queue, workerId);
    }

    @Override
    protected void startImpl() {
        SecurityManager s = System.getSecurityManager();
        final ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(group, r, ThreadWorker.this.queueConfig.getName() + "-" + ThreadWorker.this.workerId + "-worker-" + ThreadWorker.this.counter.incrementAndGet(), 0L);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        });
    }

    @Override
    protected void stopImpl() {
        this.executor.shutdown();
        try {
            boolean isOk = this.executor.awaitTermination((long)((double)this.queue.getConfig().getWorker().getExecutionTimeout() * 1.3), TimeUnit.MILLISECONDS);
            if (!isOk) {
                logger.error(this.queueConfig.getName() + "'s worker:" + this.workerId + " stop process timeout( at ThreadWorker). may be illegal state....");
            }
        }
        catch (InterruptedException e) {
            logger.error(this.queueConfig.getName() + "'s worker:" + this.workerId + " stop process Interrupted( at ThreadWorker). may be illegal state....", (Throwable)e);
        }
    }

    @Override
    protected Future<Void> doTaskAndStatusUpdate(Task task) {
        return this.executor.submit(new WorkerCallable(task, this.queue, this.workerConfig.isTrace(), true));
    }
}

