/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb.workers;

import java.util.concurrent.Callable;
import net.logstash.logback.argument.StructuredArguments;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.async.ExceptionHandlingMode;
import org.iplass.mtp.impl.async.AsyncTaskContextImpl;
import org.iplass.mtp.impl.async.ExceptionHandleable;
import org.iplass.mtp.impl.async.rdb.Queue;
import org.iplass.mtp.impl.async.rdb.Task;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.rdb.connection.ResourceHolder;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class WorkerCallable
implements Callable<Void> {
    public static final String MDC_TASK_ID = "taskId";
    private static Logger logger = LoggerFactory.getLogger(WorkerCallable.class);
    private static Logger mtpLogger = LoggerFactory.getLogger((String)"mtp.async.rdb");
    private static Logger fatalLogger = LoggerFactory.getLogger((String)"mtp.fatal.async.rdb");
    private final Task task;
    private final Queue queue;
    private final boolean trace;
    private final boolean initRH;
    private static final String LOG_TYPE_APP_ERROR = "AppError";
    private static final String LOG_TYPE_ERROR = "Error";
    private static final String LOG_ARG_QUEUE_NAME = "queue_name";
    private static final String LOG_ARG_EXECUTION_TIME = "execution_time";
    private static final String LOG_ARG_ERROR_TYPE = "error_type";
    private static final String LOG_ARG_ERROR_DESCRIPTION = "error_description";

    public WorkerCallable(Task task, Queue queue, boolean trace, boolean initRH) {
        this.task = task;
        this.queue = queue;
        this.trace = trace;
        this.initRH = initRH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        try {
            MDC.put((String)MDC_TASK_ID, (String)String.valueOf(this.task.getTaskId()));
            if (this.task.getCallable() != null && this.task.getCallable().getTraceId() != null) {
                MDC.put((String)"traceId", (String)this.task.getCallable().getTraceId());
            }
            if (this.initRH) {
                ResourceHolder.init();
            }
            final AsyncTaskContextImpl asyncTaskContext = new AsyncTaskContextImpl(this.task.getTaskId(), this.queue.getName());
            TenantContext tc = ServiceRegistry.getRegistry().getService(TenantContextService.class).getTenantContext(this.task.getTenantId());
            Void void_ = ExecuteContext.executeAs(tc, new Executable<Void>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Void execute() {
                    ExecuteContext ec = ExecuteContext.getCurrentContext();
                    try {
                        ec.setAttribute("mtp.async.AsyncTaskContext", asyncTaskContext, false);
                        if (WorkerCallable.this.task.getCallable().getUserContext() != null) {
                            AuthService as = ServiceRegistry.getRegistry().getService(AuthService.class);
                            as.doSecuredAction(WorkerCallable.this.task.getCallable().getUserContext(), () -> {
                                WorkerCallable.this.callImpl();
                                return null;
                            });
                            return null;
                        }
                        WorkerCallable.this.callImpl();
                        return null;
                    }
                    catch (Error | RuntimeException e) {
                        switch (WorkerCallable.this.task.getExceptionHandlingMode()) {
                            case RESTART: {
                                if (WorkerCallable.this.task.getRetryCount() >= WorkerCallable.this.queue.getConfig().getWorker().getMaxRetryCount()) {
                                    fatalLogger.error("queue:" + WorkerCallable.this.queue.getConfig().getName() + "'s task:" + WorkerCallable.this.task.getTaskId() + "(tenantId:" + WorkerCallable.this.task.getTenantId() + ") is failed. max retry count over.", e);
                                    return null;
                                }
                                mtpLogger.warn("queue:" + WorkerCallable.this.queue.getConfig().getName() + "'s task:" + WorkerCallable.this.task.getTaskId() + "(tenantId:" + WorkerCallable.this.task.getTenantId() + ") is failed(cause:" + e + "). re-run after a while.");
                                return null;
                            }
                            case ABORT_LOG_FATAL: 
                            case ABORT: {
                                Transaction.required(transaction -> {
                                    Throwable t = e instanceof WrapException ? e.getCause() : e;
                                    if (WorkerCallable.this.queue.taskAbort(WorkerCallable.this.task, true, t, false, false)) {
                                        if (WorkerCallable.this.task.getCallable().getActual() instanceof ExceptionHandleable) {
                                            try {
                                                ((ExceptionHandleable)((Object)WorkerCallable.this.task.getCallable().getActual())).aborted(t);
                                            }
                                            catch (Throwable ee) {
                                                fatalLogger.error("ExceptionHandleable's aborted() call failed(queue:" + WorkerCallable.this.queue.getConfig().getName() + ", task:" + WorkerCallable.this.task.getTaskId() + ",tenantId:" + WorkerCallable.this.task.getTenantId() + ")", ee);
                                                transaction.setRollbackOnly();
                                            }
                                        }
                                    } else {
                                        logger.warn("task status cant update to [abort].may be another process update status." + WorkerCallable.this.task);
                                    }
                                });
                                return null;
                            }
                        }
                        return null;
                    }
                    finally {
                        ec.removeAttribute("mtp.async.AsyncTaskContext");
                    }
                }
            });
            return void_;
        }
        finally {
            if (this.initRH) {
                ResourceHolder.fin();
            }
            MDC.remove((String)"traceId");
            MDC.remove((String)MDC_TASK_ID);
        }
    }

    private void callImpl() {
        Transaction.required(transaction -> {
            Object var6_7;
            long start;
            block13: {
                Throwable t;
                block15: {
                    block14: {
                        start = -1L;
                        if (this.trace) {
                            start = System.currentTimeMillis();
                        }
                        t = null;
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug("execute " + this.task);
                            }
                            Object res = this.task.getCallable().getActual().call();
                            if (this.task.isReturnResult()) {
                                this.task.setResult(res);
                            }
                            this.queue.taskFinish(this.task);
                            var6_7 = null;
                            if (t == null) break block13;
                            if (!this.trace) break block14;
                        }
                        catch (Error | RuntimeException e) {
                            try {
                                transaction.setRollbackOnly();
                                t = e;
                                throw e;
                                catch (Exception e2) {
                                    transaction.setRollbackOnly();
                                    t = e2;
                                    throw new WrapException(e2);
                                }
                            }
                            catch (Throwable throwable) {
                                if (t == null) {
                                    if (!this.trace) throw throwable;
                                    mtpLogger.info("{}(id={}),{},{}ms", new Object[]{this.task.getCallable(), this.task.getTaskId(), StructuredArguments.value((String)LOG_ARG_QUEUE_NAME, (Object)this.queue.getName()), StructuredArguments.value((String)LOG_ARG_EXECUTION_TIME, (Object)(System.currentTimeMillis() - start))});
                                    throw throwable;
                                }
                                if (this.trace) {
                                    mtpLogger.error("{}(id={}),{},{}ms,{},{}", new Object[]{this.task.getCallable(), this.task.getTaskId(), StructuredArguments.value((String)LOG_ARG_QUEUE_NAME, (Object)this.queue.getName()), StructuredArguments.value((String)LOG_ARG_EXECUTION_TIME, (Object)(System.currentTimeMillis() - start)), StructuredArguments.value((String)LOG_ARG_ERROR_TYPE, (Object)this.errorType(t)), StructuredArguments.value((String)LOG_ARG_ERROR_DESCRIPTION, (Object)t.getMessage()), t});
                                } else {
                                    mtpLogger.error("{}(id={}),{},{},{}", new Object[]{this.task.getCallable(), this.task.getTaskId(), StructuredArguments.value((String)LOG_ARG_QUEUE_NAME, (Object)this.queue.getName()), StructuredArguments.value((String)LOG_ARG_ERROR_TYPE, (Object)this.errorType(t)), StructuredArguments.value((String)LOG_ARG_ERROR_DESCRIPTION, (Object)t.getMessage()), t});
                                }
                                if (!(t instanceof Error)) {
                                    if (this.task.getExceptionHandlingMode() != ExceptionHandlingMode.ABORT_LOG_FATAL) throw throwable;
                                }
                                fatalLogger.error("queue:" + this.queue.getConfig().getName() + "'s task:" + this.task.getTaskId() + "(tenantId:" + this.task.getTenantId() + ") fatal error.", t);
                                throw throwable;
                            }
                        }
                        mtpLogger.error("{}(id={}),{},{}ms,{},{}", new Object[]{this.task.getCallable(), this.task.getTaskId(), StructuredArguments.value((String)LOG_ARG_QUEUE_NAME, (Object)this.queue.getName()), StructuredArguments.value((String)LOG_ARG_EXECUTION_TIME, (Object)(System.currentTimeMillis() - start)), StructuredArguments.value((String)LOG_ARG_ERROR_TYPE, (Object)this.errorType(t)), StructuredArguments.value((String)LOG_ARG_ERROR_DESCRIPTION, (Object)t.getMessage()), t});
                        break block15;
                    }
                    mtpLogger.error("{}(id={}),{},{},{}", new Object[]{this.task.getCallable(), this.task.getTaskId(), StructuredArguments.value((String)LOG_ARG_QUEUE_NAME, (Object)this.queue.getName()), StructuredArguments.value((String)LOG_ARG_ERROR_TYPE, (Object)this.errorType(t)), StructuredArguments.value((String)LOG_ARG_ERROR_DESCRIPTION, (Object)t.getMessage()), t});
                }
                if (!(t instanceof Error)) {
                    if (this.task.getExceptionHandlingMode() != ExceptionHandlingMode.ABORT_LOG_FATAL) return var6_7;
                }
                fatalLogger.error("queue:" + this.queue.getConfig().getName() + "'s task:" + this.task.getTaskId() + "(tenantId:" + this.task.getTenantId() + ") fatal error.", t);
                return var6_7;
            }
            if (!this.trace) return var6_7;
            mtpLogger.info("{}(id={}),{},{}ms", new Object[]{this.task.getCallable(), this.task.getTaskId(), StructuredArguments.value((String)LOG_ARG_QUEUE_NAME, (Object)this.queue.getName()), StructuredArguments.value((String)LOG_ARG_EXECUTION_TIME, (Object)(System.currentTimeMillis() - start))});
            return var6_7;
        });
    }

    private String errorType(Throwable t) {
        if (t instanceof ApplicationException) {
            return LOG_TYPE_APP_ERROR;
        }
        return LOG_TYPE_ERROR;
    }

    private static class WrapException
    extends RuntimeException {
        private static final long serialVersionUID = 1513733395068136003L;

        public WrapException(Throwable cause) {
            super(cause);
        }
    }
}

