/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth;

import java.util.List;
import java.util.Locale;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.EntityEventListener;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.util.StringUtil;

public class UserEntityEventListener
implements EntityEventListener {
    private AuthService authService = ServiceRegistry.getRegistry().getService(AuthService.class);
    private I18nService service = ServiceRegistry.getRegistry().getService(I18nService.class);

    private String makeName(String firstName, String lastName, String userLang) {
        String name = "";
        String locale = ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class).getLocale();
        if (StringUtil.isNotEmpty(userLang)) {
            locale = Locale.forLanguageTag(userLang).toString();
        }
        if (this.service.getLocaleFormat(locale).isLastNameIsFirst()) {
            name = this.appendName(name, lastName);
            name = this.appendName(name, firstName);
        } else {
            name = this.appendName(name, firstName);
            name = this.appendName(name, lastName);
        }
        if (name.length() != 0) {
            return name;
        }
        return null;
    }

    @Override
    public void beforeValidate(Entity entity, EntityEventContext context) {
        String userLang = (String)entity.getValue("language");
        List validateProps = (List)context.getAttribute("validateProperties");
        if (validateProps == null) {
            if (entity.getName() == null) {
                entity.setName(this.makeName((String)entity.getValue("firstName"), (String)entity.getValue("lastName"), userLang));
            }
        } else if (!validateProps.contains("name") && (validateProps.contains("firstName") || validateProps.contains("lastName") || validateProps.contains("language")) && entity.getName() == null) {
            entity.setName(this.makeName((String)entity.getValue("firstName"), (String)entity.getValue("lastName"), userLang));
        }
    }

    private String appendName(String name, String appendName) {
        if (appendName != null && !appendName.isEmpty()) {
            if (name != null && !name.isEmpty()) {
                name = name + " ";
            }
            name = name + appendName;
        }
        return name;
    }

    @Override
    public boolean beforeInsert(Entity entity, EntityEventContext context) {
        AccountManagementModule amm = this.authService.getAccountManagementModule((String)entity.getValue("accountPolicy"));
        if (amm != null && amm.canCreate()) {
            if (entity instanceof User) {
                amm.create((User)entity);
            } else {
                amm.create(((GenericEntity)entity).copyAs(User.class));
            }
        }
        return true;
    }

    @Override
    public void afterInsert(Entity entity, EntityEventContext context) {
        AccountManagementModule amm = this.authService.getAccountManagementModule((String)entity.getValue("accountPolicy"));
        if (amm != null && amm.canCreate()) {
            if (entity instanceof User) {
                amm.afterCreate((User)entity);
            } else {
                amm.afterCreate(((GenericEntity)entity).copyAs(User.class));
            }
        }
    }

    @Override
    public boolean beforeDelete(Entity entity, EntityEventContext context) {
        AccountManagementModule amm = this.authService.getAccountManagementModule();
        if (amm.canRemove()) {
            if (entity instanceof User) {
                amm.remove((User)entity);
            } else {
                amm.remove(((GenericEntity)entity).copyAs(User.class));
            }
        }
        return true;
    }

    @Override
    public boolean beforeUpdate(Entity entity, EntityEventContext context) {
        AccountManagementModule amm;
        UpdateOption uo = (UpdateOption)context.getAttribute("updateOption");
        Entity before = (Entity)context.getAttribute("beforeUpdateEntity");
        if (!uo.getUpdateProperties().contains("name") && (uo.getUpdateProperties().contains("firstName") || uo.getUpdateProperties().contains("lastName") || uo.getUpdateProperties().contains("language"))) {
            String firstName = (String)before.getValue("firstName");
            String lastName = (String)before.getValue("lastName");
            String language = (String)before.getValue("language");
            if (uo.getUpdateProperties().contains("firstName")) {
                firstName = (String)entity.getValue("firstName");
            }
            if (uo.getUpdateProperties().contains("lastName")) {
                lastName = (String)entity.getValue("lastName");
            }
            if (uo.getUpdateProperties().contains("language")) {
                language = (String)entity.getValue("language");
            }
            entity.setName(this.makeName(firstName, lastName, language));
            if (entity.getName() != null) {
                uo.getUpdateProperties().add("name");
            }
        }
        String policyName = (String)before.getValue("accountPolicy");
        if (uo.getUpdateProperties().contains("accountPolicy")) {
            policyName = (String)entity.getValue("accountPolicy");
        }
        if ((amm = this.authService.getAccountManagementModule(policyName)).canUpdate()) {
            if (entity instanceof User) {
                amm.update((User)entity, uo.getUpdateProperties());
            } else {
                amm.update(((GenericEntity)entity).copyAs(User.class), uo.getUpdateProperties());
            }
        }
        return true;
    }

    @Override
    public void afterUpdate(Entity entity, EntityEventContext context) {
        AccountManagementModule amm;
        UpdateOption uo = (UpdateOption)context.getAttribute("updateOption");
        Entity before = (Entity)context.getAttribute("beforeUpdateEntity");
        String policyName = (String)before.getValue("accountPolicy");
        if (uo.getUpdateProperties().contains("accountPolicy")) {
            policyName = (String)entity.getValue("accountPolicy");
        }
        if ((amm = this.authService.getAccountManagementModule(policyName)).canUpdate()) {
            if (entity instanceof User) {
                amm.afterUpdate((User)entity, policyName, uo.getUpdateProperties());
            } else {
                amm.afterUpdate(((GenericEntity)entity).copyAs(User.class), policyName, uo.getUpdateProperties());
            }
        }
    }

    @Override
    public void afterRestore(Entity entity) {
        AccountManagementModule amm = this.authService.getAccountManagementModule((String)entity.getValue("accountPolicy"));
        if (amm != null && amm.canRestore()) {
            if (entity instanceof User) {
                amm.restore((User)entity);
            } else {
                amm.restore(((GenericEntity)entity).copyAs(User.class));
            }
        }
    }

    @Override
    public void afterPurge(Entity entity) {
        AccountManagementModule amm = this.authService.getAccountManagementModule();
        if (amm != null && amm.canPurge()) {
            if (entity instanceof User) {
                amm.purge((User)entity);
            } else {
                amm.purge(((GenericEntity)entity).copyAs(User.class));
            }
        }
    }
}

