/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.iplass.mtp.impl.util.HashUtil;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class PasswordHashSetting {
    private String version;
    private String passwordHashAlgorithm;
    private String systemSalt;
    private int stretchCount = 1000;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPasswordHashAlgorithm() {
        return this.passwordHashAlgorithm;
    }

    public void setPasswordHashAlgorithm(String passwordHashAlgorithm) {
        this.passwordHashAlgorithm = passwordHashAlgorithm;
    }

    public String getSystemSalt() {
        return this.systemSalt;
    }

    public void setSystemSalt(String systemSalt) {
        this.systemSalt = systemSalt;
    }

    public int getStretchCount() {
        return this.stretchCount;
    }

    public void setStretchCount(int stretchCount) {
        this.stretchCount = stretchCount;
    }

    public void checkValidConfiguration() {
        try {
            MessageDigest.getInstance(this.getPasswordHashAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceConfigrationException("invalid PasswordHashAlgorithm", e);
        }
    }

    protected String hash(String password, String salt) {
        try {
            String hashTarget = password;
            for (int i = 0; i < this.stretchCount; ++i) {
                hashTarget = HashUtil.digest(hashTarget + this.systemSalt + salt, this.passwordHashAlgorithm);
            }
            return hashTarget;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

