/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.policy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.policy.AccountNotification;
import org.iplass.mtp.auth.policy.AccountNotificationListener;
import org.iplass.mtp.auth.policy.LoginNotification;
import org.iplass.mtp.auth.policy.PasswordNotification;
import org.iplass.mtp.auth.policy.PropertyNotification;
import org.iplass.mtp.auth.policy.definition.AccountNotificationListenerDefinition;
import org.iplass.mtp.auth.policy.definition.listeners.MailAccountNotificationListenerDefinition;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAccountNotificationListener;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.mail.Mail;
import org.iplass.mtp.mail.MailManager;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionListener;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaMailAccountNotificationListener
extends MetaAccountNotificationListener {
    private static final long serialVersionUID = -9056364804302316265L;
    private static final Logger fatalLog = LoggerFactory.getLogger((String)"mtp.fatal.mail");
    private static Logger logger = LoggerFactory.getLogger(MetaMailAccountNotificationListener.class);
    public static final String TENANT_BINDING_NAME = "tenant";
    public static final String USER_BINDING_NAME = "user";
    public static final String NEW_PASSWORD_BINDING_NAME = "newPassword";
    public static final String UPDATED_PROPERTY_NAMES = "updatedPropertyNames";
    private String createUserMailTemplate;
    private String credentialResetMailTemplate;
    private String createUserWithSpecifiedPasswordMailTemplate;
    private String credentialResetWithSpecifiedPasswordMailTemplate;
    private String lockedoutMailTemplate;
    private String credentialUpdatedMailTemplate;
    private String propertyUpdatedMailTemplate;
    private String removeUserMailTemplate;
    private String loginSuccessUserMailTemplate;
    private List<String> propertiesForUpdateNotification;

    public String getLoginSuccessUserMailTemplate() {
        return this.loginSuccessUserMailTemplate;
    }

    public void setLoginSuccessUserMailTemplate(String loginSuccessUserMailTemplate) {
        this.loginSuccessUserMailTemplate = loginSuccessUserMailTemplate;
    }

    public String getCreateUserWithSpecifiedPasswordMailTemplate() {
        return this.createUserWithSpecifiedPasswordMailTemplate;
    }

    public void setCreateUserWithSpecifiedPasswordMailTemplate(String createUserWithSpecifiedPasswordMailTemplate) {
        this.createUserWithSpecifiedPasswordMailTemplate = createUserWithSpecifiedPasswordMailTemplate;
    }

    public String getCredentialResetWithSpecifiedPasswordMailTemplate() {
        return this.credentialResetWithSpecifiedPasswordMailTemplate;
    }

    public void setCredentialResetWithSpecifiedPasswordMailTemplate(String credentialResetWithSpecifiedPasswordMailTemplate) {
        this.credentialResetWithSpecifiedPasswordMailTemplate = credentialResetWithSpecifiedPasswordMailTemplate;
    }

    public String getCredentialUpdatedMailTemplate() {
        return this.credentialUpdatedMailTemplate;
    }

    public void setCredentialUpdatedMailTemplate(String credentialUpdatedMailTemplate) {
        this.credentialUpdatedMailTemplate = credentialUpdatedMailTemplate;
    }

    public String getPropertyUpdatedMailTemplate() {
        return this.propertyUpdatedMailTemplate;
    }

    public void setPropertyUpdatedMailTemplate(String propertyUpdatedMailTemplate) {
        this.propertyUpdatedMailTemplate = propertyUpdatedMailTemplate;
    }

    public String getRemoveUserMailTemplate() {
        return this.removeUserMailTemplate;
    }

    public void setRemoveUserMailTemplate(String removeUserMailTemplate) {
        this.removeUserMailTemplate = removeUserMailTemplate;
    }

    public List<String> getPropertiesForUpdateNotification() {
        return this.propertiesForUpdateNotification;
    }

    public void setPropertiesForUpdateNotification(List<String> propertiesForUpdateNotification) {
        this.propertiesForUpdateNotification = propertiesForUpdateNotification;
    }

    public String getCreateUserMailTemplate() {
        return this.createUserMailTemplate;
    }

    public void setCreateUserMailTemplate(String createUserMailTemplate) {
        this.createUserMailTemplate = createUserMailTemplate;
    }

    public String getCredentialResetMailTemplate() {
        return this.credentialResetMailTemplate;
    }

    public void setCredentialResetMailTemplate(String credentialResetMailTemplate) {
        this.credentialResetMailTemplate = credentialResetMailTemplate;
    }

    public String getLockedoutMailTemplate() {
        return this.lockedoutMailTemplate;
    }

    public void setLockedoutMailTemplate(String lockedoutMailTemplate) {
        this.lockedoutMailTemplate = lockedoutMailTemplate;
    }

    @Override
    public AccountNotificationListener createInstance(String policyName, int i) {
        return new Listener();
    }

    @Override
    public AccountNotificationListenerDefinition currentConfig() {
        MailAccountNotificationListenerDefinition def = new MailAccountNotificationListenerDefinition();
        def.setCreateUserMailTemplate(this.createUserMailTemplate);
        def.setCreateUserWithSpecifiedPasswordMailTemplate(this.createUserWithSpecifiedPasswordMailTemplate);
        def.setCredentialResetMailTemplate(this.credentialResetMailTemplate);
        def.setCredentialResetWithSpecifiedPasswordMailTemplate(this.credentialResetWithSpecifiedPasswordMailTemplate);
        def.setLockedoutMailTemplate(this.lockedoutMailTemplate);
        def.setCredentialUpdatedMailTemplate(this.credentialUpdatedMailTemplate);
        def.setPropertyUpdatedMailTemplate(this.propertyUpdatedMailTemplate);
        def.setRemoveUserMailTemplate(this.removeUserMailTemplate);
        def.setLoginSuccessUserMailTemplate(this.loginSuccessUserMailTemplate);
        if (this.propertiesForUpdateNotification != null) {
            def.setPropertiesForUpdateNotification(new ArrayList<String>(this.propertiesForUpdateNotification));
        }
        return def;
    }

    @Override
    public void applyConfig(AccountNotificationListenerDefinition def) {
        MailAccountNotificationListenerDefinition mdef = (MailAccountNotificationListenerDefinition)def;
        this.createUserMailTemplate = mdef.getCreateUserMailTemplate();
        this.createUserWithSpecifiedPasswordMailTemplate = mdef.getCreateUserWithSpecifiedPasswordMailTemplate();
        this.credentialResetMailTemplate = mdef.getCredentialResetMailTemplate();
        this.credentialResetWithSpecifiedPasswordMailTemplate = mdef.getCredentialResetWithSpecifiedPasswordMailTemplate();
        this.lockedoutMailTemplate = mdef.getLockedoutMailTemplate();
        this.credentialUpdatedMailTemplate = mdef.getCredentialUpdatedMailTemplate();
        this.propertyUpdatedMailTemplate = mdef.getPropertyUpdatedMailTemplate();
        this.removeUserMailTemplate = mdef.getRemoveUserMailTemplate();
        this.loginSuccessUserMailTemplate = mdef.getLoginSuccessUserMailTemplate();
        this.propertiesForUpdateNotification = mdef.getPropertiesForUpdateNotification() != null ? new ArrayList<String>(mdef.getPropertiesForUpdateNotification()) : null;
    }

    private class Listener
    implements AccountNotificationListener {
        private MailManager mm = ManagerLocator.getInstance().getManager(MailManager.class);
        private EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);

        private Listener() {
        }

        @Override
        public void created(PasswordNotification notification) {
            if (notification.isPasswordAutoGenerated()) {
                if (MetaMailAccountNotificationListener.this.createUserMailTemplate != null) {
                    this.sendMail(notification.getUserOid(), notification.getPassword(), null, MetaMailAccountNotificationListener.this.createUserMailTemplate);
                }
            } else if (MetaMailAccountNotificationListener.this.createUserWithSpecifiedPasswordMailTemplate != null) {
                this.sendMail(notification.getUserOid(), null, null, MetaMailAccountNotificationListener.this.createUserWithSpecifiedPasswordMailTemplate);
            }
        }

        @Override
        public void credentialReset(PasswordNotification notification) {
            if (notification.isPasswordAutoGenerated()) {
                if (MetaMailAccountNotificationListener.this.credentialResetMailTemplate != null) {
                    this.sendMail(notification.getUserOid(), notification.getPassword(), null, MetaMailAccountNotificationListener.this.credentialResetMailTemplate);
                }
            } else if (MetaMailAccountNotificationListener.this.credentialResetWithSpecifiedPasswordMailTemplate != null) {
                this.sendMail(notification.getUserOid(), null, null, MetaMailAccountNotificationListener.this.credentialResetWithSpecifiedPasswordMailTemplate);
            }
        }

        @Override
        public void rockedout(AccountNotification notification) {
            if (MetaMailAccountNotificationListener.this.lockedoutMailTemplate != null) {
                this.sendMail(notification.getUserOid(), null, null, MetaMailAccountNotificationListener.this.lockedoutMailTemplate);
            }
        }

        private void sendMail(String userOid, final String newPassword, final List<String> updatedPropertyNames, final String mailTemplateName) {
            final Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
            final User user = AuthContext.doPrivileged(() -> (User)this.em.load(userOid, "mtp.auth.User", new LoadOption(false, false)));
            Transaction t = Transaction.getCurrent();
            if (t.getStatus() == TransactionStatus.ACTIVE) {
                t.addTransactionListener(new TransactionListener(){

                    @Override
                    public void afterRollback(Transaction t) {
                        if (user != null) {
                            logger.debug("Don't send mail cause transaciton rolledback:user=" + user.getAccountId());
                        }
                    }

                    @Override
                    public void afterCommit(Transaction t) {
                        Listener.this.sendMailInternal(tenant, user, newPassword, updatedPropertyNames, mailTemplateName);
                    }
                });
            } else {
                this.sendMailInternal(tenant, user, newPassword, updatedPropertyNames, mailTemplateName);
            }
        }

        private void sendMailInternal(Tenant tenant, User user, String newPassword, List<String> updatedPropertyNames, String mailTemplateName) {
            try {
                HashMap<String, Object> bindings = new HashMap<String, Object>();
                bindings.put(MetaMailAccountNotificationListener.TENANT_BINDING_NAME, tenant);
                bindings.put(MetaMailAccountNotificationListener.USER_BINDING_NAME, user);
                bindings.put(MetaMailAccountNotificationListener.NEW_PASSWORD_BINDING_NAME, newPassword);
                bindings.put(MetaMailAccountNotificationListener.UPDATED_PROPERTY_NAMES, updatedPropertyNames);
                Mail mail = this.mm.createMail(mailTemplateName, bindings);
                mail.addRecipientTo(user.getMail());
                this.mm.sendMail(mail);
            }
            catch (RuntimeException e) {
                fatalLog.error("cannot send mail:uid=" + user.getAccountId() + ",to=" + user.getMail() + ",mailTemplateName=" + mailTemplateName, (Throwable)e);
            }
        }

        @Override
        public void credentialUpdated(PasswordNotification notification) {
            if (MetaMailAccountNotificationListener.this.credentialUpdatedMailTemplate != null) {
                this.sendMail(notification.getUserOid(), notification.getPassword(), null, MetaMailAccountNotificationListener.this.credentialUpdatedMailTemplate);
            }
        }

        @Override
        public void propertyUpdated(PropertyNotification notification) {
            if (MetaMailAccountNotificationListener.this.propertyUpdatedMailTemplate != null) {
                if (MetaMailAccountNotificationListener.this.propertiesForUpdateNotification == null) {
                    this.sendMail(notification.getUserOid(), null, notification.getUpdatedPropertyNames(), MetaMailAccountNotificationListener.this.propertyUpdatedMailTemplate);
                } else if (this.contains(MetaMailAccountNotificationListener.this.propertiesForUpdateNotification, notification.getUpdatedPropertyNames())) {
                    this.sendMail(notification.getUserOid(), null, notification.getUpdatedPropertyNames(), MetaMailAccountNotificationListener.this.propertyUpdatedMailTemplate);
                }
            }
        }

        private boolean contains(List<String> propertiesForUpdateNotification, List<String> updatedPropertyNames) {
            for (String p : propertiesForUpdateNotification) {
                for (String u : updatedPropertyNames) {
                    if (!p.equals(u)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void remove(AccountNotification notification) {
            if (MetaMailAccountNotificationListener.this.removeUserMailTemplate != null) {
                this.sendMail(notification.getUserOid(), null, null, MetaMailAccountNotificationListener.this.removeUserMailTemplate);
            }
        }

        @Override
        public void loginSuccess(LoginNotification notification) {
            if (MetaMailAccountNotificationListener.this.loginSuccessUserMailTemplate != null) {
                Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
                UserContext uc = AuthContextHolder.getAuthContext().getUserContext();
                User user = uc.getUser();
                this.sendMailInternal(tenant, user, null, null, MetaMailAccountNotificationListener.this.loginSuccessUserMailTemplate);
            }
        }

        @Override
        public void loginFailed(LoginNotification notification) {
        }
    }
}

