/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.policy;

import java.util.List;
import org.iplass.mtp.auth.policy.definition.PasswordPolicyDefinition;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaPasswordPolicy
implements MetaData {
    private static final long serialVersionUID = -2469096937639131962L;
    private int maximumPasswordAge;
    private int minimumPasswordAge;
    private String passwordPattern;
    private boolean denySamePasswordAsAccountId;
    private String denyList;
    private String passwordPatternErrorMessage;
    private List<MetaLocalizedString> localizedPasswordPatternErrorMessageList;
    private int passwordHistoryCount;
    private int passwordHistoryPeriod;
    private boolean createAccountWithSpecificPassword;
    private boolean resetPasswordWithSpecificPassword;
    private String randomPasswordIncludeSigns;
    private String randomPasswordExcludeChars;
    private int randomPasswordLength;
    private int maximumRandomPasswordAge;
    private String customUserEndDate;

    public int getMaximumPasswordAge() {
        return this.maximumPasswordAge;
    }

    public void setMaximumPasswordAge(int maximumPasswordAge) {
        this.maximumPasswordAge = maximumPasswordAge;
    }

    public int getMinimumPasswordAge() {
        return this.minimumPasswordAge;
    }

    public void setMinimumPasswordAge(int minimumPasswordAge) {
        this.minimumPasswordAge = minimumPasswordAge;
    }

    public String getPasswordPattern() {
        return this.passwordPattern;
    }

    public void setPasswordPattern(String passwordPattern) {
        this.passwordPattern = passwordPattern;
    }

    public boolean isDenySamePasswordAsAccountId() {
        return this.denySamePasswordAsAccountId;
    }

    public void setDenySamePasswordAsAccountId(boolean denySamePasswordAsAccountId) {
        this.denySamePasswordAsAccountId = denySamePasswordAsAccountId;
    }

    public String getDenyList() {
        return this.denyList;
    }

    public void setDenyList(String denyList) {
        this.denyList = denyList;
    }

    public String getPasswordPatternErrorMessage() {
        return this.passwordPatternErrorMessage;
    }

    public void setPasswordPatternErrorMessage(String passwordPatternErrorMessage) {
        this.passwordPatternErrorMessage = passwordPatternErrorMessage;
    }

    public List<MetaLocalizedString> getLocalizedPasswordPatternErrorMessageList() {
        return this.localizedPasswordPatternErrorMessageList;
    }

    public void setLocalizedPasswordPatternErrorMessageList(List<MetaLocalizedString> localizedPasswordPatternErrorMessageList) {
        this.localizedPasswordPatternErrorMessageList = localizedPasswordPatternErrorMessageList;
    }

    public int getPasswordHistoryCount() {
        return this.passwordHistoryCount;
    }

    public void setPasswordHistoryCount(int passwordHistoryCount) {
        this.passwordHistoryCount = passwordHistoryCount;
    }

    public int getPasswordHistoryPeriod() {
        return this.passwordHistoryPeriod;
    }

    public void setPasswordHistoryPeriod(int passwordHistoryPeriod) {
        this.passwordHistoryPeriod = passwordHistoryPeriod;
    }

    public boolean isCreateAccountWithSpecificPassword() {
        return this.createAccountWithSpecificPassword;
    }

    public void setCreateAccountWithSpecificPassword(boolean createAccountWithSpecificPassword) {
        this.createAccountWithSpecificPassword = createAccountWithSpecificPassword;
    }

    public boolean isResetPasswordWithSpecificPassword() {
        return this.resetPasswordWithSpecificPassword;
    }

    public void setResetPasswordWithSpecificPassword(boolean resetPasswordWithSpecificPassword) {
        this.resetPasswordWithSpecificPassword = resetPasswordWithSpecificPassword;
    }

    public String getRandomPasswordIncludeSigns() {
        return this.randomPasswordIncludeSigns;
    }

    public void setRandomPasswordIncludeSigns(String randomPasswordIncludeSigns) {
        this.randomPasswordIncludeSigns = randomPasswordIncludeSigns;
    }

    public String getRandomPasswordExcludeChars() {
        return this.randomPasswordExcludeChars;
    }

    public void setRandomPasswordExcludeChars(String randomPasswordExcludeChars) {
        this.randomPasswordExcludeChars = randomPasswordExcludeChars;
    }

    public int getRandomPasswordLength() {
        return this.randomPasswordLength;
    }

    public void setRandomPasswordLength(int randomPasswordLength) {
        this.randomPasswordLength = randomPasswordLength;
    }

    public int getMaximumRandomPasswordAge() {
        return this.maximumRandomPasswordAge;
    }

    public void setMaximumRandomPasswordAge(int maximumRandomPasswordAge) {
        this.maximumRandomPasswordAge = maximumRandomPasswordAge;
    }

    public String getCustomUserEndDate() {
        return this.customUserEndDate;
    }

    public void setCustomUserEndDate(String customUserEndDate) {
        this.customUserEndDate = customUserEndDate;
    }

    @Override
    public MetaPasswordPolicy copy() {
        return ObjectUtil.deepCopy(this);
    }

    public void applyConfig(PasswordPolicyDefinition def) {
        this.maximumPasswordAge = def.getMaximumPasswordAge();
        this.minimumPasswordAge = def.getMinimumPasswordAge();
        this.passwordPattern = def.getPasswordPattern();
        this.denySamePasswordAsAccountId = def.isDenySamePasswordAsAccountId();
        this.denyList = def.getDenyList();
        this.passwordPatternErrorMessage = def.getPasswordPatternErrorMessage();
        this.localizedPasswordPatternErrorMessageList = I18nUtil.toMeta(def.getLocalizedPasswordPatternErrorMessageList());
        this.passwordHistoryCount = def.getPasswordHistoryCount();
        this.passwordHistoryPeriod = def.getPasswordHistoryPeriod();
        this.createAccountWithSpecificPassword = def.isCreateAccountWithSpecificPassword();
        this.randomPasswordIncludeSigns = def.getRandomPasswordIncludeSigns();
        this.randomPasswordExcludeChars = def.getRandomPasswordExcludeChars();
        this.randomPasswordLength = def.getRandomPasswordLength();
        this.maximumRandomPasswordAge = def.getMaximumRandomPasswordAge();
        this.customUserEndDate = def.getCustomUserEndDate();
        this.resetPasswordWithSpecificPassword = def.isResetPasswordWithSpecificPassword();
    }

    public PasswordPolicyDefinition currentConfig() {
        PasswordPolicyDefinition def = new PasswordPolicyDefinition();
        def.setMaximumPasswordAge(this.maximumPasswordAge);
        def.setMinimumPasswordAge(this.minimumPasswordAge);
        def.setPasswordPattern(this.passwordPattern);
        def.setDenySamePasswordAsAccountId(this.denySamePasswordAsAccountId);
        def.setDenyList(this.denyList);
        def.setPasswordPatternErrorMessage(this.passwordPatternErrorMessage);
        def.setLocalizedPasswordPatternErrorMessageList(I18nUtil.toDef(this.localizedPasswordPatternErrorMessageList));
        def.setPasswordHistoryCount(this.passwordHistoryCount);
        def.setPasswordHistoryPeriod(this.passwordHistoryPeriod);
        def.setCreateAccountWithSpecificPassword(this.createAccountWithSpecificPassword);
        def.setRandomPasswordIncludeSigns(this.randomPasswordIncludeSigns);
        def.setRandomPasswordExcludeChars(this.randomPasswordExcludeChars);
        def.setRandomPasswordLength(this.randomPasswordLength);
        def.setMaximumRandomPasswordAge(this.maximumRandomPasswordAge);
        def.setCustomUserEndDate(this.customUserEndDate);
        def.setResetPasswordWithSpecificPassword(this.resetPasswordWithSpecificPassword);
        return def;
    }
}

