/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.sql;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccount;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class AccountControlSQL
extends UpdateSqlHandler {
    public String createLoginStatUpdateSQL() {
        return "UPDATE T_ACCOUNT SET LOGIN_ERR_CNT=?,LOGIN_ERR_DATE=?,LAST_LOGIN_ON=? WHERE TENANT_ID = ? AND ACCOUNT_ID = ?";
    }

    public void setLoginStatUpdateParameter(RdbAdapter rdb, PreparedStatement ps, BuiltinAccount account) throws SQLException {
        ps.setInt(1, account.getLoginErrorCnt());
        ps.setTimestamp(2, account.getLoginErrorDate(), rdb.rdbCalendar());
        ps.setTimestamp(3, account.getLastLoginOn(), rdb.rdbCalendar());
        ps.setInt(4, account.getTenantId());
        ps.setString(5, account.getAccountId());
    }

    public String createRegistSQL(RdbAdapter rdb) {
        return "INSERT INTO T_ACCOUNT(TENANT_ID,ACCOUNT_ID,POL_NAME,PASSWORD,SALT,OID,LAST_LOGIN_ON,LOGIN_ERR_CNT,LOGIN_ERR_DATE,CRE_USER,CRE_DATE,UP_USER,UP_DATE,LAST_PASSWORD_CHANGE) VALUES (?,?,?,?,?,?,?,?,?,?," + rdb.systimestamp() + ",?," + rdb.systimestamp() + ", ?)";
    }

    public void setRegistParameter(RdbAdapter rdb, PreparedStatement ps, BuiltinAccount account, String user) throws SQLException {
        int num = 1;
        ps.setInt(num++, account.getTenantId());
        ps.setString(num++, account.getAccountId());
        ps.setString(num++, account.getPolicyName());
        ps.setString(num++, account.getPassword());
        ps.setString(num++, account.getSalt());
        ps.setString(num++, account.getOid());
        ps.setTimestamp(num++, account.getLastLoginOn(), rdb.rdbCalendar());
        ps.setInt(num++, account.getLoginErrorCnt());
        ps.setTimestamp(num++, account.getLoginErrorDate(), rdb.rdbCalendar());
        ps.setString(num++, user);
        ps.setString(num++, user);
        ps.setDate(num++, account.getLastPasswordChange());
    }

    public String createResetLoginErrorCntSQL(RdbAdapter rdb) {
        return "UPDATE T_ACCOUNT SET LOGIN_ERR_CNT = 0 WHERE TENANT_ID = ? AND ACCOUNT_ID = ?";
    }

    public void setResetLoginErrorCntParameter(RdbAdapter rdb, PreparedStatement ps, BuiltinAccount account) throws SQLException {
        int num = 1;
        ps.setInt(num++, account.getTenantId());
        ps.setString(num++, account.getAccountId());
    }

    public String createUpdateSQL(RdbAdapter rdb) {
        return "UPDATE T_ACCOUNT SET ACCOUNT_ID=?, POL_NAME=?,LOGIN_ERR_CNT=?, LOGIN_ERR_DATE=?,UP_USER=?, UP_DATE=" + rdb.systimestamp() + ",LAST_PASSWORD_CHANGE=? WHERE TENANT_ID=? AND OID=? AND UP_DATE=?";
    }

    public void setUpdateParameter(RdbAdapter rdb, PreparedStatement ps, BuiltinAccount account, String user) throws SQLException {
        int num = 1;
        ps.setString(num++, account.getAccountId());
        ps.setString(num++, account.getPolicyName());
        ps.setInt(num++, account.getLoginErrorCnt());
        ps.setTimestamp(num++, account.getLoginErrorDate(), rdb.rdbCalendar());
        ps.setString(num++, user);
        ps.setDate(num++, account.getLastPasswordChange());
        ps.setInt(num++, account.getTenantId());
        ps.setString(num++, account.getOid());
        ps.setTimestamp(num++, account.getUpdateDate(), rdb.rdbCalendar());
    }

    public String createUpdatePasswordSQL(RdbAdapter rdb) {
        return "UPDATE T_ACCOUNT SET PASSWORD=?,SALT=?,LOGIN_ERR_CNT=0,LOGIN_ERR_DATE=null,LAST_PASSWORD_CHANGE=?,UP_USER=?,UP_DATE=" + rdb.systimestamp() + " WHERE TENANT_ID=? AND ACCOUNT_ID=?";
    }

    public void setUpdatePasswordParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String accountId, String newPassword, String salt, Date lastPasswordChange, String user) throws SQLException {
        int num = 1;
        ps.setString(num++, newPassword);
        ps.setString(num++, salt);
        ps.setDate(num++, lastPasswordChange);
        ps.setString(num++, user);
        ps.setInt(num++, tenantId);
        ps.setString(num++, accountId);
    }

    public String createDeleteSQL(RdbAdapter rdb) {
        return "DELETE FROM T_ACCOUNT WHERE TENANT_ID=? AND ACCOUNT_ID=?";
    }

    public void setDeleteParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String accountId) throws SQLException {
        ps.setInt(1, tenantId);
        ps.setString(2, accountId);
    }
}

