/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccount;
import org.iplass.mtp.impl.rdb.adapter.QuerySqlHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class AccountSelectSQL
extends QuerySqlHandler {
    private static final String ACCOUNT_SELECT_SQL = "SELECT TENANT_ID,ACCOUNT_ID,POL_NAME,PASSWORD,SALT,OID,LAST_LOGIN_ON,LOGIN_ERR_CNT,LOGIN_ERR_DATE,LAST_PASSWORD_CHANGE,CRE_USER,CRE_DATE,UP_USER,UP_DATE FROM T_ACCOUNT ";

    public String createAccountSQL() {
        return "SELECT TENANT_ID,ACCOUNT_ID,POL_NAME,PASSWORD,SALT,OID,LAST_LOGIN_ON,LOGIN_ERR_CNT,LOGIN_ERR_DATE,LAST_PASSWORD_CHANGE,CRE_USER,CRE_DATE,UP_USER,UP_DATE FROM T_ACCOUNT WHERE TENANT_ID = ? AND ACCOUNT_ID = ? ";
    }

    public void setAccountParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String accountId) throws SQLException {
        int index = 1;
        ps.setInt(index++, tenantId);
        ps.setString(index++, accountId);
    }

    public String createAccountFromOidSQL() {
        return "SELECT TENANT_ID,ACCOUNT_ID,POL_NAME,PASSWORD,SALT,OID,LAST_LOGIN_ON,LOGIN_ERR_CNT,LOGIN_ERR_DATE,LAST_PASSWORD_CHANGE,CRE_USER,CRE_DATE,UP_USER,UP_DATE FROM T_ACCOUNT WHERE TENANT_ID = ? AND OID = ? ";
    }

    public void setAccountFromOidParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String oid) throws SQLException {
        int index = 1;
        ps.setInt(index++, tenantId);
        ps.setString(index++, oid);
    }

    public BuiltinAccount getAccount(ResultSet rs, RdbAdapter rdb) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        BuiltinAccount ret = new BuiltinAccount();
        int index = 1;
        ret.setTenantId(rs.getInt(index++));
        ret.setAccountId(rs.getString(index++));
        ret.setPolicyName(rs.getString(index++));
        ret.setPassword(rs.getString(index++));
        ret.setSalt(rs.getString(index++));
        ret.setOid(rs.getString(index++));
        ret.setLastLoginOn(rs.getTimestamp(index++, rdb.rdbCalendar()));
        ret.setLoginErrorCnt(rs.getInt(index++));
        ret.setLoginErrorDate(rs.getTimestamp(index++, rdb.rdbCalendar()));
        ret.setLastPasswordChange(rs.getDate(index++, rdb.javaCalendar()));
        ret.setCreateUser(rs.getString(index++));
        ret.setCreateDate(rs.getTimestamp(index++, rdb.rdbCalendar()));
        ret.setUpdateUser(rs.getString(index++));
        ret.setUpdateDate(rs.getTimestamp(index++, rdb.rdbCalendar()));
        return ret;
    }

    public String createExistAccount() {
        return "SELECT COUNT(ID) FROM T_ACCOUNT WHERE TENANT_ID = ? AND ACCOUNT_ID = ? ";
    }

    public void setExistAccount(RdbAdapter rdb, PreparedStatement ps, int tenantId, String accountId) throws SQLException {
        int index = 1;
        ps.setInt(index++, tenantId);
        ps.setString(index++, accountId);
    }
}

