/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.iplass.mtp.impl.auth.authenticate.builtin.Password;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class PasswordHistoryUpdateSQL
extends UpdateSqlHandler {
    public String createInsertSQL(RdbAdapter rdb) {
        return "INSERT INTO T_PASS_HI(TENANT_ID,ACCOUNT_ID,PASSWORD,SALT,UP_DATE) VALUES (?,?,?,?,?)";
    }

    public void setInsertParameter(RdbAdapter rdb, PreparedStatement ps, Password pass) throws SQLException {
        int num = 1;
        ps.setInt(num++, pass.getTenantId());
        ps.setString(num++, pass.getUid());
        ps.setString(num++, pass.getConvertedPassword());
        ps.setString(num++, pass.getSalt());
        ps.setTimestamp(num++, pass.getUpdateDate(), rdb.rdbCalendar());
    }

    public String createDeleteSQL(RdbAdapter rdb) {
        return "DELETE FROM T_PASS_HI WHERE TENANT_ID=? AND ACCOUNT_ID=?";
    }

    public void setDeleteParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String accountId) throws SQLException {
        ps.setInt(1, tenantId);
        ps.setString(2, accountId);
    }

    public String createDeleteByDateSQL(RdbAdapter rdb) {
        return "DELETE FROM T_PASS_HI WHERE TENANT_ID=? AND ACCOUNT_ID=? AND UP_DATE<=?";
    }

    public void setDeleteByDateParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String accountId, Timestamp date) throws SQLException {
        ps.setInt(1, tenantId);
        ps.setString(2, accountId);
        ps.setTimestamp(3, date, rdb.rdbCalendar());
    }

    public String createUpdateAccountIdSQL(RdbAdapter rdb) {
        return "UPDATE T_PASS_HI SET ACCOUNT_ID=? WHERE TENANT_ID=? AND ACCOUNT_ID=?";
    }

    public void setUpdateAccountIdSQL(RdbAdapter rdb, PreparedStatement ps, int tenantId, String oldAccountId, String newAccountId) throws SQLException {
        ps.setString(1, newAccountId);
        ps.setInt(2, tenantId);
        ps.setString(3, oldAccountId);
    }
}

