/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.ldap;

import java.util.Map;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.DefaultUserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.ldap.LdapAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.ldap.LdapAuthStrategy;
import org.iplass.mtp.impl.auth.authenticate.ldap.NeoLdapAuthStrategy;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticationProvider
extends AuthenticationProviderBase {
    public static final String USERNAME_TOKEN = "${userName}";
    public static final String TENANTNAME_TOKEN = "${tenantName}";
    public static final String USERDN_TOKEN = "${userDn}";
    private static Logger logger = LoggerFactory.getLogger(LdapAuthenticationProvider.class);
    private Map<String, Object> jndiEnv;
    private boolean getUser;
    private boolean getGroup;
    private boolean groupAsTenant;
    private String userBaseDn;
    private String groupBaseDn;
    private String userDn;
    private String userFilter;
    private String uniqueKeyAttribute;
    private String[] userAttribute;
    private String groupFilter;
    private String groupCodeAttribute;
    private String tenantGroupCode;
    private LdapAuthStrategy actual;

    @Override
    public AccountHandle login(Credential credential) {
        return this.actual.login(credential);
    }

    @Override
    public void logout(AccountHandle user) {
        this.actual.logout(user);
    }

    @Override
    public Class<? extends Credential> getCredentialType() {
        return IdPasswordCredential.class;
    }

    @Override
    public void destroyed() {
        this.actual.destroyed();
    }

    @Override
    protected Class<? extends AccountHandle> getAccountHandleClassForTrust() {
        return LdapAccountHandle.class;
    }

    @Override
    public void inited(AuthService s, Config config) {
        boolean userEntityResolverIsNull = this.getUserEntityResolver() == null;
        super.inited(s, config);
        if (userEntityResolverIsNull) {
            logger.warn("userEntityResolver not specified, so use DefaultUserEntityResolver and User's accountId as unmodifiableUniqueKeyProperty");
            ((DefaultUserEntityResolver)this.getUserEntityResolver()).setUnmodifiableUniqueKeyProperty("accountId");
        }
        if (this.jndiEnv != null && this.jndiEnv.get("java.naming.factory.initial") == null) {
            this.jndiEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        this.actual = new NeoLdapAuthStrategy(this);
    }

    @Override
    public AccountManagementModule getAccountManagementModule() {
        return NO_UPDATABLE_AMM;
    }

    public Map<String, Object> getJndiEnv() {
        return this.jndiEnv;
    }

    public void setJndiEnv(Map<String, Object> jndiEnv) {
        this.jndiEnv = jndiEnv;
    }

    public String getUserBaseDn() {
        return this.userBaseDn;
    }

    public void setUserBaseDn(String userBaseDn) {
        this.userBaseDn = userBaseDn;
    }

    public String getGroupBaseDn() {
        return this.groupBaseDn;
    }

    public void setGroupBaseDn(String groupBaseDn) {
        this.groupBaseDn = groupBaseDn;
    }

    public boolean isGetUser() {
        return this.getUser;
    }

    public void setGetUser(boolean getUser) {
        this.getUser = getUser;
    }

    public boolean isGetGroup() {
        return this.getGroup;
    }

    public void setGetGroup(boolean getGroup) {
        this.getGroup = getGroup;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public String getUniqueKeyAttribute() {
        return this.uniqueKeyAttribute;
    }

    public void setUniqueKeyAttribute(String uniqueKeyAttribute) {
        this.uniqueKeyAttribute = uniqueKeyAttribute;
    }

    public String[] getUserAttribute() {
        return this.userAttribute;
    }

    public void setUserAttribute(String[] userAttribute) {
        this.userAttribute = userAttribute;
    }

    public String getGroupFilter() {
        return this.groupFilter;
    }

    public void setGroupFilter(String groupFilter) {
        this.groupFilter = groupFilter;
    }

    public String getGroupCodeAttribute() {
        return this.groupCodeAttribute;
    }

    public void setGroupCodeAttribute(String groupCodeAttribute) {
        this.groupCodeAttribute = groupCodeAttribute;
    }

    public boolean isGroupAsTenant() {
        return this.groupAsTenant;
    }

    public void setGroupAsTenant(boolean groupAsTenant) {
        this.groupAsTenant = groupAsTenant;
    }

    public String getTenantGroupCode() {
        return this.tenantGroupCode;
    }

    public void setTenantGroupCode(String tenantGroupCode) {
        this.tenantGroupCode = tenantGroupCode;
    }
}

