/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.simpletoken;

import java.util.List;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.auth.login.token.SimpleAuthTokenCredential;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.UserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.simpletoken.SimpleAuthTokenAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.simpletoken.SimpleAuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthTokenAuthenticationProvider
extends AuthenticationProviderBase {
    private static Logger logger = LoggerFactory.getLogger(SimpleAuthTokenAuthenticationProvider.class);
    private SimpleAuthTokenAccountManagementModule amm = new SimpleAuthTokenAccountManagementModule();
    private SimpleAuthTokenHandler tokenHandler;
    private String authTokenType = "SAT";
    private Class<? extends Credential> credentialTypeForTrust;
    private Class<? extends AccountHandle> accountHandleClassForTrust;
    private AuthenticationPolicyService authPolicyService = ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
    private AuthTokenService tokenService = ServiceRegistry.getRegistry().getService(AuthTokenService.class);

    public void setCredentialTypeForTrust(Class<? extends Credential> credentialTypeForTrust) {
        this.credentialTypeForTrust = credentialTypeForTrust;
    }

    public void setAccountHandleClassForTrust(Class<? extends AccountHandle> accountHandleClassForTrust) {
        this.accountHandleClassForTrust = accountHandleClassForTrust;
    }

    @Override
    public Class<? extends Credential> getCredentialType() {
        return SimpleAuthTokenCredential.class;
    }

    @Override
    protected Class<? extends Credential> getCredentialTypeForTrust() {
        return this.credentialTypeForTrust;
    }

    @Override
    protected Class<? extends AccountHandle> getAccountHandleClassForTrust() {
        return this.accountHandleClassForTrust;
    }

    public String getAuthTokenType() {
        return this.authTokenType;
    }

    public void setAuthTokenType(String authTokenType) {
        this.authTokenType = authTokenType;
    }

    @Override
    public void inited(AuthService service, Config config) {
        super.inited(service, config);
        this.tokenHandler = (SimpleAuthTokenHandler)this.tokenService.getHandler(this.authTokenType);
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void cleanupData() {
    }

    @Override
    public AccountHandle login(Credential credential) {
        if (credential instanceof SimpleAuthTokenCredential) {
            SimpleAuthTokenCredential cre = (SimpleAuthTokenCredential)credential;
            if (cre.getToken() == null) {
                throw new IllegalArgumentException("specify token");
            }
            int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
            if (cre.getToken() != null) {
                AuthToken crToken = new AuthToken();
                crToken.decodeToken(cre.getToken());
                if (!this.authTokenType.equals(crToken.getType())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("no match token type:" + crToken.getType() + " so continue to another AuthProvider");
                    }
                    return null;
                }
                if (crToken.getToken() == null) {
                    throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.authenticate.rememberme.failed", new Object[0]));
                }
                AuthToken stToken = this.tokenHandler.authTokenStore().getBySeries(tenantId, this.authTokenType, crToken.getSeries());
                if (stToken == null) {
                    throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.authenticate.rememberme.failed", new Object[0]));
                }
                if (!this.tokenHandler.checkTokenValid(crToken.getToken(), stToken)) {
                    throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.authenticate.rememberme.failed", new Object[0]));
                }
                MetaAuthenticationPolicy.AuthenticationPolicyRuntime pol = this.authPolicyService.getOrDefault(stToken.getPolicyName());
                if (pol == null) {
                    throw new LoginFailedException(CoreResourceBundleUtil.resourceString("impl.auth.authenticate.rememberme.failed", new Object[0]));
                }
                return new SimpleAuthTokenAccountHandle(stToken.getOwnerId(), stToken.getSeries(), stToken.getPolicyName());
            }
        }
        return null;
    }

    @Override
    public void logout(AccountHandle user) {
    }

    @Override
    public AccountManagementModule getAccountManagementModule() {
        return this.amm;
    }

    private class SimpleAuthTokenAccountManagementModule
    implements AccountManagementModule {
        private SimpleAuthTokenAccountManagementModule() {
        }

        @Override
        public boolean canCreate() {
            return false;
        }

        @Override
        public boolean canUpdate() {
            return false;
        }

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public boolean canRestore() {
            return false;
        }

        @Override
        public boolean canPurge() {
            return false;
        }

        @Override
        public boolean canUpdateCredential() {
            return false;
        }

        @Override
        public boolean canResetCredential() {
            return false;
        }

        @Override
        public void create(User user) {
        }

        @Override
        public void afterCreate(User user) {
        }

        @Override
        public void update(User user, List<String> updateProperties) {
        }

        @Override
        public void afterUpdate(User user, String policyName, List<String> updateProperties) {
        }

        @Override
        public void remove(User user) {
            UserEntityResolver uer = SimpleAuthTokenAuthenticationProvider.this.getUserEntityResolver();
            SimpleAuthTokenAuthenticationProvider.this.tokenHandler.authTokenStore().delete(ExecuteContext.getCurrentContext().getClientTenantId(), SimpleAuthTokenAuthenticationProvider.this.authTokenType, user.getValue(uer.getUnmodifiableUniqueKeyProperty()).toString());
        }

        @Override
        public void restore(User user) {
        }

        @Override
        public void purge(User user) {
        }

        @Override
        public void updateCredential(Credential oldCredential, Credential newCredential) throws CredentialUpdateException {
        }

        @Override
        public void resetCredential(Credential credential) throws CredentialUpdateException {
        }

        @Override
        public boolean canResetLockoutStatus() {
            return false;
        }

        @Override
        public void resetLockoutStatus(String accountId) {
        }
    }
}

