/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.token;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.List;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenStore;
import org.iplass.mtp.impl.auth.authenticate.token.HashSetting;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.util.random.SecureRandomGenerator;
import org.iplass.mtp.impl.util.random.SecureRandomService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;

public abstract class AuthTokenHandler
implements ServiceInitListener<AuthTokenService> {
    private String store;
    private String type;
    private boolean visible = true;
    private List<HashSetting> hashSettings;
    private String secureRandomGeneratorName;
    private AuthTokenService service;
    private AuthTokenStore authTokenStore;
    private SecureRandomGenerator generator;

    public List<HashSetting> getHashSettings() {
        return this.hashSettings;
    }

    public void setHashSettings(List<HashSetting> hashSettings) {
        this.hashSettings = hashSettings;
    }

    public String getSecureRandomGeneratorName() {
        return this.secureRandomGeneratorName;
    }

    public void setSecureRandomGeneratorName(String secureRandomGeneratorName) {
        this.secureRandomGeneratorName = secureRandomGeneratorName;
    }

    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void inited(AuthTokenService service, Config config) {
        this.service = service;
        if (this.hashSettings != null) {
            for (HashSetting hs : this.hashSettings) {
                try {
                    MessageDigest.getInstance(hs.getHashAlgorithm());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ServiceConfigrationException("invalid HashAlgorithm", e);
                }
            }
        }
        this.authTokenStore = this.hashSettings != null && this.hashSettings.size() > 0 ? new HashingAuthTokenStore(service.getStore(this.store)) : service.getStore(this.store);
        if (this.secureRandomGeneratorName != null) {
            this.generator = ServiceRegistry.getRegistry().getService(SecureRandomService.class).createGenerator(this.secureRandomGeneratorName);
        }
    }

    @Override
    public void destroyed() {
    }

    public AuthTokenStore authTokenStore() {
        return this.authTokenStore;
    }

    public AuthTokenService getService() {
        return this.service;
    }

    public String newTokenString(AuthTokenInfo tokenInfo) {
        if (this.generator != null) {
            return this.generator.secureRandomToken();
        }
        return RandomHolder.random.secureRandomToken();
    }

    public String newSeriesString(String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        return RandomHolder.random.secureRandomToken();
    }

    public boolean checkTokenValid(String inputToken, AuthToken storeToken) {
        if (storeToken == null || inputToken == null) {
            return false;
        }
        if (this.hashSettings == null || this.hashSettings.size() == 0) {
            return storeToken.getToken().equals(inputToken);
        }
        String[] verHash = this.divVerAndHash(storeToken.getToken());
        HashSetting hs = this.selectSetting(verHash[0]);
        if (hs == null) {
            return verHash[1].equals(inputToken);
        }
        return verHash[1].equals(hs.hash(inputToken));
    }

    private HashSetting selectSetting(String ver) {
        if (ver == null || ver.length() == 0 || this.hashSettings == null) {
            return null;
        }
        for (int i = this.hashSettings.size() - 1; i >= 0; --i) {
            HashSetting set = this.hashSettings.get(i);
            if (!ver.equals(set.getVersion())) continue;
            return set;
        }
        return null;
    }

    private String[] divVerAndHash(String token) {
        if (token != null && token.length() != 0 && token.charAt(0) == '$') {
            int index = token.indexOf(36, 1);
            return new String[]{token.substring(1, index), token.substring(index + 1)};
        }
        return new String[]{null, token};
    }

    public AuthToken newAuthToken(String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        String seriesString = this.newSeriesString(userUniqueId, policyName, tokenInfo);
        String tokenString = this.newTokenString(tokenInfo);
        Serializable details = this.createDetails(seriesString, tokenString, userUniqueId, policyName, tokenInfo);
        return new AuthToken(tenantId, this.getType(), userUniqueId, seriesString, tokenString, policyName, new Timestamp(System.currentTimeMillis()), details);
    }

    protected abstract Serializable createDetails(String var1, String var2, String var3, String var4, AuthTokenInfo var5);

    public abstract AuthTokenInfo toAuthTokenInfo(AuthToken var1);

    public abstract Credential toCredential(AuthToken var1);

    private class HashingAuthTokenStore
    implements AuthTokenStore {
        private AuthTokenStore store;

        private HashingAuthTokenStore(AuthTokenStore store) {
            this.store = store;
        }

        @Override
        public AuthToken getBySeries(int tenantId, String type, String series) {
            return this.store.getBySeries(tenantId, type, series);
        }

        @Override
        public List<AuthToken> getByOwner(int tenantId, String type, String userUniqueKey) {
            return this.store.getByOwner(tenantId, type, userUniqueKey);
        }

        private AuthToken hashToken(AuthToken token) {
            HashSetting hs = (HashSetting)AuthTokenHandler.this.hashSettings.get(AuthTokenHandler.this.hashSettings.size() - 1);
            String hashedTokenString = "$" + hs.getVersion() + "$" + hs.hash(token.getToken());
            return new AuthToken(token.getTenantId(), token.getType(), token.getOwnerId(), token.getSeries(), hashedTokenString, token.getPolicyName(), token.getStartDate(), token.getDetails());
        }

        @Override
        public void create(AuthToken token) {
            this.store.create(this.hashToken(token));
        }

        @Override
        public void update(AuthToken newToken, AuthToken currentToken) {
            this.store.update(this.hashToken(newToken), currentToken);
        }

        @Override
        public void delete(int tenantId, String type, String userUniqueKey) {
            this.store.delete(tenantId, type, userUniqueKey);
        }

        @Override
        public void deleteBySeries(int tenantId, String type, String series) {
            this.store.deleteBySeries(tenantId, type, series);
        }

        @Override
        public void deleteByDate(int tenantId, String type, Timestamp ts) {
            this.store.deleteByDate(tenantId, type, ts);
        }
    }

    private static class RandomHolder {
        static final SecureRandomGenerator random = ServiceRegistry.getRegistry().getService(SecureRandomService.class).createGenerator("authTokenGenerator");

        private RandomHolder() {
        }
    }
}

