/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.token;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenStore;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class AuthTokenService
implements Service {
    public static final String DEFAULT_STORE_NAME = "default";
    private Map<String, AuthTokenStore> storeMap;
    private AuthTokenStore defaultStore;
    private Map<String, AuthTokenHandler> handlerMap;

    public Collection<AuthTokenStore> getStores() {
        return this.storeMap.values();
    }

    public AuthTokenStore getStore(String type) {
        AuthTokenStore store = this.storeMap.get(type);
        if (store == null) {
            store = this.defaultStore;
        }
        return store;
    }

    public AuthTokenHandler getHandler(String type) {
        return this.handlerMap.get(type);
    }

    public Collection<AuthTokenHandler> getHandlers() {
        return this.handlerMap.values();
    }

    @Override
    public void init(Config config) {
        this.storeMap = config.getValue("storeMap", Map.class);
        this.defaultStore = this.storeMap.get(DEFAULT_STORE_NAME);
        this.handlerMap = new HashMap<String, AuthTokenHandler>();
        List<AuthTokenHandler> handlers = config.getValues("handler", AuthTokenHandler.class);
        if (handlers != null) {
            for (AuthTokenHandler ah : handlers) {
                this.handlerMap.put(ah.getType(), ah);
            }
        }
    }

    @Override
    public void destroy() {
    }
}

