/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.token;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenKey;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenStore;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenUpdateException;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.spi.ServiceRegistry;

public class CacheOnlyAuthTokenStore
implements AuthTokenStore,
ServiceInitListener<AuthTokenService> {
    private static final String DEFAULT_TOKEN_CACHE_NAMESPACE = "mtp.auth.cacheOnlyAuthTokenStore/DEFAULT";
    private String cacheStoreName = "mtp.auth.cacheOnlyAuthTokenStore/DEFAULT";
    private CacheStore cacheStore;

    @Override
    public void inited(AuthTokenService service, Config config) {
        CacheService cs = ServiceRegistry.getRegistry().getService(CacheService.class);
        this.cacheStore = cs.getCache(this.cacheStoreName);
    }

    @Override
    public void destroyed() {
    }

    public String getCacheStoreName() {
        return this.cacheStoreName;
    }

    public void setCacheStoreName(String cacheStoreName) {
        this.cacheStoreName = cacheStoreName;
    }

    @Override
    public AuthToken getBySeries(int tenantId, String type, String series) {
        CacheEntry ce = this.cacheStore.get(new AuthTokenKey(tenantId, type, series));
        if (ce != null) {
            AuthToken at = (AuthToken)ce.getValue();
            if (at != null) {
                at = ObjectUtil.deepCopy(at);
            }
            return at;
        }
        return null;
    }

    @Override
    public List<AuthToken> getByOwner(int tenantId, String type, String userUniqueKey) {
        String key = this.indexKey0(tenantId, type, userUniqueKey);
        List<CacheEntry> l = this.cacheStore.getListByIndex(0, key);
        if (l != null) {
            ArrayList<AuthToken> ret = new ArrayList<AuthToken>();
            for (CacheEntry e : l) {
                if (e.getValue() == null) continue;
                ret.add(ObjectUtil.deepCopy((AuthToken)e.getValue()));
            }
            return ret;
        }
        return null;
    }

    private String indexKey0(int tenantId, String type, String userUniqueKey) {
        return new StringBuffer().append(tenantId).append('-').append(type).append('-').append(userUniqueKey).toString();
    }

    @Override
    public void create(AuthToken token) {
        CacheEntry ce = new CacheEntry((Object)new AuthTokenKey(token.getTenantId(), token.getType(), token.getSeries()), (Object)token, this.indexKey0(token.getTenantId(), token.getType(), token.getOwnerId()));
        if (this.cacheStore.putIfAbsent(ce) != null) {
            throw new AuthTokenUpdateException("duplicate key entry:" + token.getSeries());
        }
    }

    @Override
    public void update(AuthToken newToken, AuthToken currentToken) {
        CacheEntry ce = this.cacheStore.get(new AuthTokenKey(currentToken.getTenantId(), currentToken.getType(), currentToken.getSeries()));
        if (ce == null || ce.getValue() == null) {
            throw new AuthTokenUpdateException("currentToken is invalid:" + currentToken.getSeries());
        }
        AuthToken cachedToken = (AuthToken)ce.getValue();
        if (!cachedToken.getToken().equals(currentToken.getToken())) {
            throw new AuthTokenUpdateException("currentToken is invalid:" + currentToken.getSeries());
        }
        CacheEntry newCe = new CacheEntry((Object)new AuthTokenKey(newToken.getTenantId(), newToken.getType(), newToken.getSeries()), (Object)newToken, this.indexKey0(newToken.getTenantId(), newToken.getType(), newToken.getOwnerId()));
        if (!this.cacheStore.replace(ce, newCe)) {
            throw new AuthTokenUpdateException("currentToken is invalid:" + currentToken.getSeries());
        }
    }

    @Override
    public void delete(int tenantId, String type, String userUniqueKey) {
        this.cacheStore.removeByIndex(1, this.indexKey0(tenantId, type, userUniqueKey));
    }

    @Override
    public void deleteBySeries(int tenantId, String type, String series) {
        this.cacheStore.remove(new AuthTokenKey(tenantId, type, series));
    }

    @Override
    public void deleteByDate(int tenantId, String type, Timestamp ts) {
    }
}

