/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.token.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.sql.DetailWrapper;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class AuthTokenUpdateSQL
extends UpdateSqlHandler {
    public String createInsertSQL() {
        return "INSERT INTO T_ATOKEN(TENANT_ID,T_TYPE,U_KEY,SERIES,TOKEN,POL_NAME,S_DATE,T_INFO) VALUES (?,?,?,?,?,?,?,?)";
    }

    public void setInsertParameter(RdbAdapter rdb, PreparedStatement ps, AuthToken token, boolean saveDetailAsJson, ObjectMapper om) throws SQLException, JsonProcessingException {
        ps.setInt(1, token.getTenantId());
        ps.setString(2, token.getType());
        ps.setString(3, token.getOwnerId());
        ps.setString(4, token.getSeries());
        ps.setString(5, token.getToken());
        ps.setString(6, token.getPolicyName());
        ps.setTimestamp(7, token.getStartDate(), rdb.rdbCalendar());
        if (token.getDetails() == null) {
            ps.setBytes(8, null);
        } else if (saveDetailAsJson) {
            ps.setBytes(8, om.writeValueAsBytes((Object)new DetailWrapper(token.getDetails())));
        } else {
            ps.setBytes(8, this.toBin(token.getDetails()));
        }
    }

    public String createDeleteSQL() {
        return "DELETE FROM T_ATOKEN WHERE TENANT_ID=? AND T_TYPE=? AND U_KEY=?";
    }

    public void setDeleteParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String type, String uniqueKey) throws SQLException {
        ps.setInt(1, tenantId);
        ps.setString(2, type);
        ps.setString(3, uniqueKey);
    }

    public String createDeleteBySeriesSQL() {
        return "DELETE FROM T_ATOKEN WHERE TENANT_ID=? AND T_TYPE=? AND SERIES=?";
    }

    public void setDeleteBySeriesParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String type, String series) throws SQLException {
        ps.setInt(1, tenantId);
        ps.setString(2, type);
        ps.setString(3, series);
    }

    public String createDeleteByDateSQL() {
        return "DELETE FROM T_ATOKEN WHERE TENANT_ID=? AND T_TYPE=? S_DATE<=?";
    }

    public void setDeleteByDateParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String type, Timestamp date) throws SQLException {
        ps.setInt(1, tenantId);
        ps.setString(2, type);
        ps.setTimestamp(3, date, rdb.rdbCalendar());
    }

    public String createUpdateStrictSQL() {
        return "UPDATE T_ATOKEN SET TOKEN=?,S_DATE=?,T_INFO=? WHERE TENANT_ID=? AND T_TYPE=? AND SERIES=? AND TOKEN=?";
    }

    public void setUpdateStrictParameter(RdbAdapter rdb, PreparedStatement ps, AuthToken newToken, AuthToken currentToken, boolean saveDetailAsJson, ObjectMapper om) throws SQLException, JsonProcessingException {
        ps.setString(1, newToken.getToken());
        ps.setTimestamp(2, newToken.getStartDate(), rdb.rdbCalendar());
        if (newToken.getDetails() == null) {
            ps.setBytes(3, null);
        } else if (saveDetailAsJson) {
            ps.setBytes(3, om.writeValueAsBytes((Object)new DetailWrapper(newToken.getDetails())));
        } else {
            ps.setBytes(3, this.toBin(newToken.getDetails()));
        }
        ps.setInt(4, newToken.getTenantId());
        ps.setString(5, newToken.getType());
        ps.setString(6, newToken.getSeries());
        ps.setString(7, currentToken.getToken());
    }

    byte[] toBin(Serializable obj) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(obj);
            return byteOut.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

