/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin;

import java.util.HashMap;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authorize.AuthorizationProvider;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextHandler;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationProvider;
import org.iplass.mtp.impl.auth.authorize.builtin.group.GroupCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.group.GroupContext;
import org.iplass.mtp.impl.auth.authorize.builtin.role.RoleCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.role.RoleContext;
import org.iplass.mtp.impl.cache.CacheController;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantResource;
import org.iplass.mtp.spi.ServiceRegistry;

public class TenantAuthorizeContext
implements TenantResource {
    private static final String ROLE_CACHE_NAMESPACE = "mtp.auth.builtin.role";
    private static final String GROUP_CACHE_NAMESPACE = "mtp.auth.builtin.group";
    private TenantContext tc;
    private HashMap<Class<? extends AuthorizationContextHandler>, CacheController<String, BuiltinAuthorizationContext>> contextCacheMap;
    private CacheController<String, RoleContext> roleCache;
    private CacheController<String, GroupContext> groupCache;
    private boolean grantAllPermissionsToAdmin;
    private boolean declareTransactionExplicitly;

    public CacheController<String, BuiltinAuthorizationContext> getContextCache(Class<? extends AuthorizationContextHandler> key) {
        return this.contextCacheMap.get(key);
    }

    @Override
    public void init(TenantContext tenantContext) {
        this.tc = tenantContext;
        this.contextCacheMap = new HashMap();
        CacheService cs = ServiceRegistry.getRegistry().getService(CacheService.class);
        this.roleCache = new CacheController<String, RoleContext>(cs.getCache("mtp.auth.builtin.role/" + this.tc.getTenantId()), false, 0, new RoleCacheLogic(this), true, true);
        this.groupCache = new CacheController<String, GroupContext>(cs.getCache("mtp.auth.builtin.group/" + this.tc.getTenantId()), false, 0, new GroupCacheLogic(this), true, true);
        AuthorizationProvider authz = ServiceRegistry.getRegistry().getService(AuthService.class).getAuthorizationProvider();
        if (authz instanceof BuiltinAuthorizationProvider) {
            BuiltinAuthorizationProvider bauthz = (BuiltinAuthorizationProvider)authz;
            this.grantAllPermissionsToAdmin = bauthz.isGrantAllPermissionsToAdmin();
            if (bauthz.getAuthorizationContextHandler() != null) {
                for (AuthorizationContextHandler ach : bauthz.getAuthorizationContextHandler()) {
                    this.contextCacheMap.put(ach.getClass(), ach.initCache(this));
                }
            }
            this.declareTransactionExplicitly = bauthz.isDeclareTransactionExplicitly();
        } else {
            this.grantAllPermissionsToAdmin = false;
        }
    }

    @Override
    public void destory() {
        for (CacheController<String, BuiltinAuthorizationContext> c : this.contextCacheMap.values()) {
            c.invalidateCacheStore();
        }
        this.roleCache.invalidateCacheStore();
        this.groupCache.invalidateCacheStore();
    }

    public boolean isGrantAllPermissionsToAdmin() {
        return this.grantAllPermissionsToAdmin;
    }

    public boolean isDeclareTransactionExplicitly() {
        return this.declareTransactionExplicitly;
    }

    public TenantContext getTenantContext() {
        return this.tc;
    }

    public RoleContext getRoleContext(final String role) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != this.tc.getTenantId()) {
            return ExecuteContext.executeAs(this.tc, new Executable<RoleContext>(){

                @Override
                public RoleContext execute() {
                    return (RoleContext)TenantAuthorizeContext.this.roleCache.get(role);
                }
            });
        }
        return this.roleCache.get(role);
    }

    public void notifyRoleCreate(final String role) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != this.tc.getTenantId()) {
            ExecuteContext.executeAs(this.tc, new Executable<Void>(){

                @Override
                public Void execute() {
                    TenantAuthorizeContext.this.roleCache.notifyCreate(new RoleCacheLogic(TenantAuthorizeContext.this).load(role));
                    return null;
                }
            });
        } else {
            this.roleCache.notifyCreate(new RoleCacheLogic(this).load(role));
        }
    }

    public void notifyRoleDelete(String role, final RoleContext roleContext) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != this.tc.getTenantId()) {
            ExecuteContext.executeAs(this.tc, new Executable<Void>(){

                @Override
                public Void execute() {
                    TenantAuthorizeContext.this.roleCache.notifyDelete(roleContext);
                    return null;
                }
            });
        } else {
            this.roleCache.notifyDelete(roleContext);
        }
    }

    public void notifyRoleUpdate(final String role) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != this.tc.getTenantId()) {
            ExecuteContext.executeAs(this.tc, new Executable<Void>(){

                @Override
                public Void execute() {
                    RoleContext context = new RoleCacheLogic(TenantAuthorizeContext.this).load(role);
                    if (context == null) {
                        TenantAuthorizeContext.this.roleCache.notifyDelete(new RoleContext(role, 0L, null, TenantAuthorizeContext.this));
                    } else {
                        TenantAuthorizeContext.this.roleCache.notifyUpdate(context);
                    }
                    return null;
                }
            });
        } else {
            RoleContext context = new RoleCacheLogic(this).load(role);
            if (context == null) {
                this.roleCache.notifyDelete(new RoleContext(role, 0L, null, this));
            } else {
                this.roleCache.notifyUpdate(context);
            }
        }
    }

    public GroupContext getGroupContext(final String group) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != this.tc.getTenantId()) {
            return ExecuteContext.executeAs(this.tc, new Executable<GroupContext>(){

                @Override
                public GroupContext execute() {
                    return (GroupContext)TenantAuthorizeContext.this.groupCache.get(group);
                }
            });
        }
        return this.groupCache.get(group);
    }

    public void notifyGroupCreate(final String group) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != this.tc.getTenantId()) {
            ExecuteContext.executeAs(this.tc, new Executable<Void>(){

                @Override
                public Void execute() {
                    TenantAuthorizeContext.this.groupCache.notifyCreate(new GroupCacheLogic(TenantAuthorizeContext.this).load(group));
                    return null;
                }
            });
        } else {
            this.groupCache.notifyCreate(new GroupCacheLogic(this).load(group));
        }
    }

    public void notifyGroupDelete(String group, final GroupContext groupContext) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != this.tc.getTenantId()) {
            ExecuteContext.executeAs(this.tc, new Executable<Void>(){

                @Override
                public Void execute() {
                    TenantAuthorizeContext.this.groupCache.notifyDelete(groupContext);
                    return null;
                }
            });
        } else {
            this.groupCache.notifyDelete(groupContext);
        }
    }

    public void notifyGroupUpdate(final String group) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != this.tc.getTenantId()) {
            ExecuteContext.executeAs(this.tc, new Executable<Void>(){

                @Override
                public Void execute() {
                    GroupContext context = new GroupCacheLogic(TenantAuthorizeContext.this).load(group);
                    if (context == null) {
                        TenantAuthorizeContext.this.groupCache.notifyDelete(new GroupContext(null, group, null, null, TenantAuthorizeContext.this));
                    } else {
                        TenantAuthorizeContext.this.groupCache.notifyUpdate(context);
                    }
                    return null;
                }
            });
        } else {
            GroupContext context = new GroupCacheLogic(this).load(group);
            if (context == null) {
                this.groupCache.notifyDelete(new GroupContext(null, group, null, null, this));
            } else {
                this.groupCache.notifyUpdate(context);
            }
        }
    }
}

