/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.entity;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.permission.EntityPropertyPermission;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformerSupport;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.Refer;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.auth.authorize.AuthorizationProvider;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationProvider;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.BuiltinEntityAuthContext;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.EntityAuthContextHandler;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.HasReferencePropertyChecker;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.auth.EntityAuthContext;
import org.iplass.mtp.impl.entity.auth.EntityQueryAuthContextHolder;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.entity.versioning.VersionedQueryNormalizer;
import org.iplass.mtp.spi.ServiceRegistry;

class AuthQueryASTTransformer
extends ASTTransformerSupport {
    private TenantAuthorizeContext tenantAuthContext;
    private BuiltinEntityAuthContext entityAuthContext;
    private EntityPermission.Action action;
    private EntityPropertyPermission.Action propAction;
    private AuthContextHolder user;
    private EntityHandler eh;
    private EntityContext entityContext;
    private AuthQueryASTTransformer parent;
    private HashMap<String, PermissionInfo> permissionCheckReslt = new HashMap();
    private EntityAuthContextHandler eacHandler;
    private boolean isVersionSpecify;
    private boolean isConditonNode;

    AuthQueryASTTransformer(TenantAuthorizeContext tenantAuthContext, BuiltinEntityAuthContext entityAuthContext, EntityPermission.Action action, AuthContextHolder user, EntityHandler eh, EntityContext entityContext, AuthQueryASTTransformer parent) {
        this(tenantAuthContext, entityAuthContext, action, null, user, eh, entityContext, parent);
    }

    AuthQueryASTTransformer(TenantAuthorizeContext tenantAuthContext, BuiltinEntityAuthContext entityAuthContext, EntityPermission.Action action, EntityPropertyPermission.Action propAction, AuthContextHolder user, EntityHandler eh, EntityContext entityContext, AuthQueryASTTransformer parent) {
        this.tenantAuthContext = tenantAuthContext;
        this.entityAuthContext = entityAuthContext;
        this.action = action;
        this.user = user;
        this.eh = eh;
        this.entityContext = entityContext;
        this.parent = parent;
        this.propAction = propAction;
        if (propAction == null) {
            this.propAction = this.toPropertyAction(action);
        }
        this.isVersionSpecify = false;
        this.isConditonNode = false;
    }

    public Query transform(Query q) {
        return (Query)q.accept(this);
    }

    private EntityPropertyPermission.Action toPropertyAction(EntityPermission.Action action) {
        switch (action) {
            case CREATE: {
                return EntityPropertyPermission.Action.CREATE;
            }
            case REFERENCE: {
                return EntityPropertyPermission.Action.REFERENCE;
            }
            case UPDATE: {
                return EntityPropertyPermission.Action.UPDATE;
            }
        }
        return null;
    }

    private boolean isPermit(String propName) {
        PermissionInfo p = this.permissionCheckReslt.get(propName);
        if (p == null) {
            int index = propName.indexOf(46);
            while (p == null) {
                if (index > -1) {
                    String refPropName = propName.substring(0, index);
                    if (!this.isPermit(refPropName)) {
                        p = new PermissionInfo(false, true);
                    } else {
                        PropertyHandler ph = this.eh.getPropertyCascade(refPropName, this.entityContext);
                        if (ph instanceof ReferencePropertyHandler) {
                            ReferencePropertyHandler rph = (ReferencePropertyHandler)ph;
                            EntityHandler reh = rph.getReferenceEntityHandler(this.entityContext);
                            EntityPermission ep = new EntityPermission(reh.getMetaData().getName(), this.action);
                            if (!this.user.checkPermission(ep)) {
                                p = new PermissionInfo(false, true);
                            } else {
                                PermissionInfo refPI = new PermissionInfo(true, true);
                                EntityAuthContext refEac = (EntityAuthContext)this.user.getAuthorizationContext(ep);
                                if (refEac instanceof BuiltinEntityAuthContext) {
                                    refPI.limitCondition = ((BuiltinEntityAuthContext)refEac).addLimitingCondition(null, this.action, this.user);
                                }
                                this.permissionCheckReslt.put(refPropName, refPI);
                            }
                        }
                    }
                } else {
                    int dotIndex = propName.indexOf(46);
                    if (dotIndex < 0) {
                        p = new PermissionInfo(this.entityAuthContext.isPermit(propName, this.propAction, this.user), false);
                    } else {
                        String ref = propName.substring(0, dotIndex);
                        String prop = propName.substring(dotIndex + 1);
                        ReferencePropertyHandler rph = (ReferencePropertyHandler)this.eh.getPropertyCascade(ref, this.entityContext);
                        if (rph == null) {
                            throw new NullPointerException(" reference:" + ref + " of " + this.eh.getMetaData().getName() + " not found.");
                        }
                        EntityHandler reh = rph.getReferenceEntityHandler(this.entityContext);
                        p = this.user.checkPermission(new EntityPropertyPermission(reh.getMetaData().getName(), prop, this.propAction)) ? new PermissionInfo(true, false) : new PermissionInfo(false, false);
                    }
                }
                index = propName.indexOf(46, index + 1);
            }
            this.permissionCheckReslt.put(propName, p);
        }
        return p.isPermit;
    }

    private int unnestCount(String propName) {
        for (int i = 0; i < propName.length(); ++i) {
            if (propName.charAt(i) == '.') continue;
            return i;
        }
        return 0;
    }

    @Override
    public ASTNode visit(EntityField entityField) {
        String propName = entityField.getPropertyName();
        int unnestCount = this.unnestCount(propName);
        AuthQueryASTTransformer target = this;
        if (unnestCount > 0) {
            propName = propName.substring(unnestCount);
            for (int i = 0; i < unnestCount; ++i) {
                target = target.parent;
                if (target != null) continue;
                throw new QueryException("can't correlate outer query on :" + entityField);
            }
        }
        if (target.isConditonNode && VersionedQueryNormalizer.isVersionProperty(propName)) {
            target.isVersionSpecify = true;
        }
        if (target.propAction == null || target.isPermit(propName) || propName.equalsIgnoreCase("this")) {
            return super.visit(entityField);
        }
        return new Literal(null);
    }

    @Override
    public ASTNode visit(SubQuery subQuery) {
        Query subQ = subQuery.getQuery();
        Condition on = subQuery.getOn();
        EntityHandler subEh = this.entityContext.getHandlerByName(subQ.getFrom().getEntityName());
        if (subEh == null) {
            throw new QueryException("subQuery's Entity not defined:" + subQuery);
        }
        BuiltinEntityAuthContext subEac = (BuiltinEntityAuthContext)this.user.getAuthorizationContext(new EntityPermission(subQ.getFrom().getEntityName(), this.action));
        TenantAuthorizeContext subTac = subEac.getTenantAuthContext();
        AuthQueryASTTransformer subTrans = new AuthQueryASTTransformer(subTac, subEac, this.action, this.propAction, this.user, subEh, this.entityContext, this);
        if (on != null) {
            on = (Condition)on.accept(subTrans);
        }
        subQ = subTrans.transform(subQ);
        return new SubQuery(subQ, on);
    }

    @Override
    public ASTNode visit(Query query) {
        Query q = (Query)super.visit(query);
        HasReferencePropertyChecker queryHasRefChecker = new HasReferencePropertyChecker();
        q.accept(queryHasRefChecker);
        EntityQueryAuthContextHolder eqaContext = EntityQueryAuthContextHolder.getContext();
        if (queryHasRefChecker.hasReferenceProperty() && this.permissionCheckReslt != null) {
            for (final Map.Entry<String, PermissionInfo> e : this.permissionCheckReslt.entrySet()) {
                ReferencePropertyHandler rph;
                EntityHandler refEh;
                PermissionInfo pInfo = e.getValue();
                if (!pInfo.isReference || pInfo.limitCondition == null || (refEh = (rph = (ReferencePropertyHandler)this.eh.getPropertyCascade(e.getKey(), this.entityContext)).getReferenceEntityHandler(this.entityContext)) == null) continue;
                Refer r = q.refer(e.getKey());
                if (eqaContext.isWithoutConditionReferenceName(e.getKey())) continue;
                HasReferencePropertyChecker refChecker = new HasReferencePropertyChecker();
                pInfo.limitCondition.accept(refChecker);
                if (refChecker.hasReferenceProperty()) {
                    pInfo.limitCondition = this.toOidInCondition(refEh.getMetaData().getName(), pInfo.limitCondition, e.getKey());
                }
                QueryVisitorSupport qvs = new QueryVisitorSupport(){

                    @Override
                    public boolean visit(EntityField entityField) {
                        entityField.setPropertyName((String)e.getKey() + "." + entityField.getPropertyName());
                        return super.visit(entityField);
                    }

                    @Override
                    public boolean visit(SubQuery scalarSubQuery) {
                        return false;
                    }
                };
                pInfo.limitCondition.accept(qvs);
                if (r.getCondition() == null) {
                    r.setCondition(pInfo.limitCondition);
                    continue;
                }
                r.setCondition(new And(r.getCondition(), pInfo.limitCondition));
            }
        }
        Condition cond = null;
        UserBinding userBind = this.user.newUserBinding(this.tenantAuthContext);
        if (!userBind.isGrantAllPermissions() && !eqaContext.isWithoutConditionReferenceName("this")) {
            cond = this.entityAuthContext.addLimitingCondition(null, this.action, this.user);
        }
        if (cond == null) {
            return q;
        }
        HasReferencePropertyChecker hasRefChecker = new HasReferencePropertyChecker();
        cond.accept(hasRefChecker);
        if (hasRefChecker.hasReferenceProperty()) {
            cond = this.toOidInCondition(this.eh.getMetaData().getName(), cond, "this");
        }
        if (q.getWhere() == null || q.getWhere().getCondition() == null) {
            q.where(cond);
        } else {
            And and = new And();
            and.addExpression(new Paren(q.getWhere().getCondition()));
            and.addExpression(new Paren(cond));
            q.where(and);
        }
        return q;
    }

    @Override
    public ASTNode visit(Where where) {
        this.isConditonNode = true;
        ASTNode node = super.visit(where);
        this.isConditonNode = false;
        return node;
    }

    private Condition toOidInCondition(String fromEntityName, Condition cond, String refName) {
        Query q = new Query();
        q.setSelect(new Select(true, new ValueExpression[]{new EntityField("oid"), new EntityField("version")}));
        q.from(fromEntityName);
        q.where(cond);
        if (this.isVersionSpecify) {
            q.setVersioned(true);
        }
        SubQuery sq = new SubQuery(q);
        AuthorizationProvider azp = ServiceRegistry.getRegistry().getService(AuthService.class).getAuthorizationProvider();
        if (azp instanceof BuiltinAuthorizationProvider) {
            if (this.eacHandler == null) {
                this.eacHandler = (EntityAuthContextHandler)((BuiltinAuthorizationProvider)azp).getAuthorizationContextHandler(EntityPermission.class);
            }
            if (this.eacHandler.isUseCorrelatedSubqueryOnEntityLimitCondition()) {
                sq.on(refName, "this");
            }
        }
        In in = new In(new String[]{"oid", "version"}, sq);
        return in;
    }

    private class PermissionInfo {
        boolean isPermit;
        boolean isReference;
        Condition limitCondition;

        PermissionInfo(boolean isPermit, boolean isReference) {
            this.isPermit = isPermit;
            this.isReference = isReference;
        }

        public String toString() {
            return String.valueOf(this.isPermit);
        }
    }
}

