/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.entity;

import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.permission.EntityPropertyPermission;
import org.iplass.mtp.impl.auth.authorize.AuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextHandler;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.DefaultEntityAuthContext;
import org.iplass.mtp.impl.auth.authorize.builtin.entity.EntityAuthContextCacheLogic;
import org.iplass.mtp.impl.core.ExecuteContext;

public class EntityAuthContextHandler
extends AuthorizationContextHandler {
    private static final Class<?>[] PERM_TYPE = new Class[]{EntityPermission.class, EntityPropertyPermission.class};
    private boolean useCorrelatedSubqueryOnEntityLimitCondition;

    public boolean isUseCorrelatedSubqueryOnEntityLimitCondition() {
        return this.useCorrelatedSubqueryOnEntityLimitCondition;
    }

    public void setUseCorrelatedSubqueryOnEntityLimitCondition(boolean useCorrelatedSubqueryOnEntityLimitCondition) {
        this.useCorrelatedSubqueryOnEntityLimitCondition = useCorrelatedSubqueryOnEntityLimitCondition;
    }

    @Override
    public Class<? extends Permission>[] permissionType() {
        return PERM_TYPE;
    }

    @Override
    protected String cacheNamespace() {
        return "mtp.auth.builtin.entity";
    }

    @Override
    protected String contextName(Permission permission) {
        if (permission instanceof EntityPermission) {
            return ((EntityPermission)permission).getDefinitionName();
        }
        return ((EntityPropertyPermission)permission).getDefinitionName();
    }

    @Override
    protected String toMetaDataPath(String contextName) {
        return "/entity/" + contextName.replace('.', '/');
    }

    @Override
    protected AuthorizationContextCacheLogic newAuthorizeContextCacheLogic(TenantAuthorizeContext tac) {
        return new EntityAuthContextCacheLogic(tac);
    }

    @Override
    protected AuthorizationContext defaultAuthorizationContext(String contextName, TenantAuthorizeContext tac) {
        if (ExecuteContext.getCurrentContext().getClientTenantId() != tac.getTenantContext().getTenantId()) {
            return new DefaultEntityAuthContext(contextName, null, null, tac, true);
        }
        return new DefaultEntityAuthContext(contextName, null, null, tac, false);
    }
}

