/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.role;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.role.RoleContext;
import org.iplass.mtp.impl.cache.LoadingAdapter;
import org.iplass.mtp.transaction.Transaction;

public class RoleCacheLogic
implements LoadingAdapter<String, RoleContext> {
    public static final String ROLE_DEF_NAME = "mtp.auth.Role";
    public static final String ROLE_CODE = "code";
    public static final String ROLE_PRIORITY = "priority";
    public static final String ROLE_CONDITION = "condition";
    public static final String ROLE_CONDITION_DEF_NAME = "mtp.auth.RoleCondition";
    public static final String ROLE_CONDITION_EXPRESSION = "expression";
    public static final String ROLE_CONDITION_ROLE = "role";
    private final TenantAuthorizeContext authorizeContext;
    private EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);

    public RoleCacheLogic(TenantAuthorizeContext authorizeContext) {
        this.authorizeContext = authorizeContext;
    }

    @Override
    public RoleContext load(String key) {
        if (this.authorizeContext.isDeclareTransactionExplicitly()) {
            return Transaction.required(t -> this.loadImpl(key));
        }
        return this.loadImpl(key);
    }

    private RoleContext loadImpl(String key) {
        return AuthContext.doPrivileged(() -> {
            Query q = new Query().select(ROLE_CODE, ROLE_PRIORITY, "condition.expression").from(ROLE_DEF_NAME).where(new Equals(ROLE_CODE, key));
            final ArrayList expressionList = new ArrayList();
            final boolean[] isFind = new boolean[]{false};
            final long[] priority = new long[]{0L};
            this.em.search(q, new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] dataModel) {
                    String exp;
                    isFind[0] = true;
                    if (dataModel[1] != null) {
                        priority[0] = (Long)dataModel[1];
                    }
                    if ((exp = (String)dataModel[2]) != null && exp.trim().length() != 0) {
                        expressionList.add(exp);
                    }
                    return true;
                }
            });
            if (!isFind[0]) {
                return null;
            }
            return new RoleContext(key, priority[0], expressionList.toArray(new String[expressionList.size()]), this.authorizeContext);
        });
    }

    @Override
    public String getKey(RoleContext val) {
        return val.getRoleCode();
    }

    @Override
    public List<RoleContext> loadByIndex(int indexType, Object indexVal) {
        return null;
    }

    @Override
    public long getVersion(RoleContext value) {
        return 0L;
    }

    @Override
    public Object getIndexVal(int indexType, RoleContext value) {
        return null;
    }
}

