/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.role;

import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.EntityEventListener;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.core.ExecuteContext;

public class RoleConditionEntityEventListener
implements EntityEventListener {
    private String getRoleCode(Entity roleCondEntity) {
        Query q = new Query().select("role.code").from("mtp.auth.RoleCondition").where(new Equals("oid", roleCondEntity.getOid()));
        final String[] ret = new String[]{null};
        ManagerLocator.getInstance().getManager(EntityManager.class).search(q, new Predicate<Object[]>(){

            @Override
            public boolean test(Object[] dataModel) {
                ret[0] = (String)dataModel[0];
                return false;
            }
        });
        return ret[0];
    }

    @Override
    public boolean beforeDelete(Entity entity, EntityEventContext context) {
        String roleCode = this.getRoleCode(entity);
        context.setAttribute("roleCode", roleCode);
        return true;
    }

    @Override
    public void afterDelete(Entity entity, EntityEventContext context) {
        String roleCode = (String)context.getAttribute("roleCode");
        if (roleCode != null) {
            ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).notifyRoleUpdate(roleCode);
        }
    }

    @Override
    public void afterInsert(Entity entity, EntityEventContext context) {
        String roleCode = this.getRoleCode(entity);
        if (roleCode != null) {
            ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).notifyRoleUpdate(roleCode);
        }
    }

    @Override
    public boolean beforeUpdate(Entity entity, EntityEventContext context) {
        String roleCode = this.getRoleCode(entity);
        context.setAttribute("beforeRoleCode", roleCode);
        return true;
    }

    @Override
    public void afterUpdate(Entity entity, EntityEventContext context) {
        String afterRoleCode;
        String beforeRoleCode = (String)context.getAttribute("beforeRoleCode");
        if (beforeRoleCode != null) {
            ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).notifyRoleUpdate(beforeRoleCode);
        }
        if ((afterRoleCode = this.getRoleCode(entity)) != null && !afterRoleCode.equals(beforeRoleCode)) {
            ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).notifyRoleUpdate(afterRoleCode);
        }
    }

    @Override
    public void afterRestore(Entity entity) {
        String roleCode = this.getRoleCode(entity);
        if (roleCode != null) {
            ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).notifyRoleUpdate(roleCode);
        }
    }
}

