/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.role;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.EntityEventListener;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.role.RoleContext;
import org.iplass.mtp.impl.core.ExecuteContext;

public class RoleEntityEventListener
implements EntityEventListener {
    @Override
    public boolean beforeDelete(Entity entity, EntityEventContext context) {
        Entity before = ManagerLocator.getInstance().getManager(EntityManager.class).load(entity.getOid(), entity.getDefinitionName(), new LoadOption(true, false));
        if (before != null) {
            RoleContext beforeRoleContext = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).getRoleContext((String)before.getValue("code"));
            context.setAttribute("roleContextForDel", beforeRoleContext);
        }
        return true;
    }

    @Override
    public void afterDelete(Entity entity, EntityEventContext context) {
        RoleContext beforeRoleContext = (RoleContext)context.getAttribute("roleContextForDel");
        if (beforeRoleContext != null) {
            ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).notifyRoleDelete(beforeRoleContext.getRoleCode(), beforeRoleContext);
        }
    }

    @Override
    public void afterInsert(Entity entity, EntityEventContext context) {
        ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).notifyRoleCreate((String)entity.getValue("code"));
    }

    @Override
    public boolean beforeUpdate(Entity entity, EntityEventContext context) {
        Entity before = ManagerLocator.getInstance().getManager(EntityManager.class).load(entity.getOid(), entity.getDefinitionName(), new LoadOption(true, false));
        if (before != null) {
            RoleContext beforeRoleContext = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).getRoleContext((String)before.getValue("code"));
            context.setAttribute("roleContextForUpdate", beforeRoleContext);
        }
        return true;
    }

    @Override
    public void afterUpdate(Entity entity, EntityEventContext context) {
        RoleContext beforeRoleContext = (RoleContext)context.getAttribute("roleContextForUpdate");
        if (beforeRoleContext != null) {
            TenantAuthorizeContext tAuth = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class);
            if (!beforeRoleContext.getRoleCode().equals(entity.getValue("code"))) {
                tAuth.notifyRoleDelete(beforeRoleContext.getRoleCode(), beforeRoleContext);
            }
            tAuth.notifyRoleUpdate((String)entity.getValue("code"));
        }
    }

    @Override
    public void afterRestore(Entity entity) {
        ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).notifyRoleCreate((String)entity.getValue("code"));
    }
}

