/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.log;

import java.util.List;
import org.iplass.mtp.impl.auth.log.AuthLogger;
import org.iplass.mtp.impl.auth.log.Slf4jAuthLogger;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;

public class AuthLoggerService
implements Service {
    private AuthLogger[] loggers;
    private AuthLogger defaultLogger;

    public AuthLogger[] getLoggers() {
        return this.loggers;
    }

    public AuthLogger getAuthLogger(String name) {
        if (name == null) {
            return this.defaultLogger;
        }
        if (this.loggers != null) {
            for (AuthLogger al : this.loggers) {
                if (!al.getLoggerName().equals(name)) continue;
                return al;
            }
        }
        return this.defaultLogger;
    }

    @Override
    public void init(Config config) {
        List<?> loggerList = config.getBeans("logger");
        if (loggerList != null) {
            this.loggers = loggerList.toArray(new AuthLogger[loggerList.size()]);
        }
        if (this.loggers != null) {
            for (AuthLogger al : this.loggers) {
                if (!"default".equals(al.getLoggerName())) continue;
                this.defaultLogger = al;
                break;
            }
        }
        if (this.defaultLogger == null) {
            this.defaultLogger = new Slf4jAuthLogger();
            this.defaultLogger.inited(this, config);
        }
    }

    @Override
    public void destroy() {
    }
}

