/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.log;

import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.argument.StructuredArguments;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.log.AuthLogConstants;
import org.iplass.mtp.impl.auth.log.AuthLoggerBase;
import org.iplass.mtp.impl.auth.log.AuthLoggerService;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jAuthLogger
extends AuthLoggerBase {
    public static final String DEFAULT_LOGGER_NAME = "mtp.auth";
    protected Logger auditLog;
    private String slf4LoggerName;

    public String getSlf4LoggerName() {
        return this.slf4LoggerName;
    }

    public void setSlf4LoggerName(String slf4LoggerName) {
        this.slf4LoggerName = slf4LoggerName;
    }

    @Override
    public void inited(AuthLoggerService service, Config config) {
        if (this.slf4LoggerName == null) {
            this.slf4LoggerName = DEFAULT_LOGGER_NAME;
        }
        this.auditLog = LoggerFactory.getLogger((String)this.slf4LoggerName);
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void loginFail(Credential credential, Exception e) {
        if (this.auditLog.isWarnEnabled()) {
            if (e == null) {
                this.auditLog.warn("{},{},{}", new Object[]{this.argId(credential), AuthLogConstants.Operation.LOGIN.getArg(), AuthLogConstants.State.FAIL.getArg()});
            } else {
                this.auditLog.warn("{},{},{},{}", new Object[]{this.argId(credential), AuthLogConstants.Operation.LOGIN.getArg(), AuthLogConstants.State.FAIL.getArg(), this.argExceptionMessage(e)});
            }
        }
    }

    @Override
    public void loginLocked(Credential credential) {
        if (this.auditLog.isWarnEnabled()) {
            this.auditLog.warn("{},{},{}", new Object[]{this.argId(credential), AuthLogConstants.Operation.LOGIN.getArg(), AuthLogConstants.State.LOCKED.getArg()});
        }
    }

    @Override
    public void loginSuccess(UserContext user) {
        if (this.auditLog.isInfoEnabled()) {
            this.auditLog.info("{},{},{}", new Object[]{this.argId(user), AuthLogConstants.Operation.LOGIN.getArg(), AuthLogConstants.State.SUCCESS.getArg()});
        }
    }

    @Override
    public void loginPasswordExpired(Credential credential) {
        if (this.auditLog.isInfoEnabled()) {
            this.auditLog.info("{},{},{}", new Object[]{this.argId(credential), AuthLogConstants.Operation.LOGIN.getArg(), AuthLogConstants.State.PASSWORD_EXPIRED.getArg()});
        }
    }

    @Override
    public void updatePasswordSuccess(Credential oldCredential) {
        if (this.auditLog.isInfoEnabled()) {
            this.auditLog.info("{},{},{}", new Object[]{this.argId(oldCredential), AuthLogConstants.Operation.UPDATE_PASSWORD.getArg(), AuthLogConstants.State.SUCCESS.getArg()});
        }
    }

    @Override
    public void updatePasswordFail(Credential oldCredential, CredentialUpdateException e) {
        if (this.auditLog.isWarnEnabled()) {
            this.auditLog.warn("{},{},{},{}", new Object[]{this.argId(oldCredential), AuthLogConstants.Operation.UPDATE_PASSWORD.getArg(), AuthLogConstants.State.FAIL.getArg(), this.argExceptionMessage(e)});
        }
    }

    @Override
    public void resetPasswordSuccess(Credential credential) {
        if (this.auditLog.isInfoEnabled()) {
            this.auditLog.info("{},{},{}", new Object[]{this.argId(credential), AuthLogConstants.Operation.RESET_PASSSROD.getArg(), AuthLogConstants.State.SUCCESS.getArg()});
        }
    }

    protected StructuredArgument argId(Credential credential) {
        return StructuredArguments.value((String)"id", (Object)credential.getId());
    }

    protected StructuredArgument argId(UserContext user) {
        return StructuredArguments.value((String)"id", (Object)user.getUser().getAccountId());
    }

    protected StructuredArgument argExceptionMessage(Exception exception) {
        return StructuredArguments.value((String)"exceptionMessage", (Object)exception.toString());
    }
}

