/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.util.LinkedHashMap;
import java.util.TreeSet;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.builtin.FineGrainedLockIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FineGrainedLockState
implements AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(FineGrainedLockState.class);
    private TargetIndex[] targetIndex;
    private CacheEntry newEntry;
    private CacheEntry oldEntry;

    FineGrainedLockState(CacheEntry newEntry, CacheEntry oldEntry, FineGrainedLockIndex[] fineGrainedLockIndex) {
        this.newEntry = newEntry;
        this.oldEntry = oldEntry;
        this.targetIndex = new TargetIndex[fineGrainedLockIndex.length];
        for (int i = 0; i < this.targetIndex.length; ++i) {
            this.targetIndex[i] = new TargetIndex();
            TreeSet<Object> sortedIndexValues = new TreeSet<Object>();
            this.targetIndex[i].indexValueMap = new LinkedHashMap();
            Object key = newEntry != null ? newEntry.getKey() : oldEntry.getKey();
            this.targetIndex[i].shardIndex = fineGrainedLockIndex[i].shardIndex(key);
            if (newEntry != null) {
                this.addToSortedIndexValues(sortedIndexValues, newEntry.getIndexValue(i));
            }
            if (oldEntry != null) {
                this.addToSortedIndexValues(sortedIndexValues, oldEntry.getIndexValue(i));
            }
            for (Object e : sortedIndexValues) {
                this.targetIndex[i].indexValueMap.put(e, fineGrainedLockIndex[i].getIndexValue(e, true));
            }
            for (FineGrainedLockIndex.IndexValue indexValue : this.targetIndex[i].indexValueMap.values()) {
                indexValue.writeLock(this.targetIndex[i].shardIndex).lock();
            }
        }
    }

    private void addToSortedIndexValues(TreeSet<Object> sortedIndexValues, Object ival) {
        if (ival instanceof Object[]) {
            for (Object o : (Object[])ival) {
                sortedIndexValues.add(o);
            }
        } else if (ival != null) {
            sortedIndexValues.add(ival);
        }
    }

    public void maintain() {
        for (int i = 0; i < this.targetIndex.length; ++i) {
            Object iv;
            FineGrainedLockIndex.IndexValue iv2;
            Object ival;
            if (this.oldEntry != null) {
                ival = this.oldEntry.getIndexValue(i);
                if (ival instanceof Object[]) {
                    for (Object o : (Object[])ival) {
                        iv2 = this.targetIndex[i].indexValueMap.get(o);
                        iv2.remove(this.targetIndex[i].shardIndex, this.oldEntry.getKey());
                    }
                } else if (ival != null) {
                    iv = this.targetIndex[i].indexValueMap.get(ival);
                    ((FineGrainedLockIndex.IndexValue)iv).remove(this.targetIndex[i].shardIndex, this.oldEntry.getKey());
                }
            }
            if (this.newEntry == null) continue;
            ival = this.newEntry.getIndexValue(i);
            if (ival instanceof Object[]) {
                for (Object o : (Object[])ival) {
                    iv2 = this.targetIndex[i].indexValueMap.get(o);
                    iv2.add(this.targetIndex[i].shardIndex, this.newEntry.getKey());
                }
                continue;
            }
            if (ival == null) continue;
            iv = this.targetIndex[i].indexValueMap.get(ival);
            ((FineGrainedLockIndex.IndexValue)iv).add(this.targetIndex[i].shardIndex, this.newEntry.getKey());
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.targetIndex.length; ++i) {
            for (FineGrainedLockIndex.IndexValue iv : this.targetIndex[i].indexValueMap.values()) {
                try {
                    iv.writeLock(this.targetIndex[i].shardIndex).unlock();
                }
                catch (IllegalMonitorStateException e) {
                    logger.warn("Illegal Lock State in FineGrainedLock." + e, (Throwable)e);
                }
            }
        }
    }

    private class TargetIndex {
        LinkedHashMap<Object, FineGrainedLockIndex.IndexValue> indexValueMap;
        int shardIndex;

        private TargetIndex() {
        }
    }
}

