/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cluster.channel.http;

import java.util.concurrent.Callable;
import org.iplass.mtp.impl.cluster.Message;
import org.iplass.mtp.impl.cluster.channel.http.HttpMessageChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageTask
implements Callable<Void> {
    private static Logger logger = LoggerFactory.getLogger(SendMessageTask.class);
    private static Logger fatalLog = LoggerFactory.getLogger((String)"mtp.fatal.cluster");
    private final Message message;
    private final HttpMessageChannel channel;
    private final String url;
    private volatile int retryCount;

    public SendMessageTask(Message message, String url, int retryCount, HttpMessageChannel channel) {
        this.message = message;
        this.url = url;
        this.channel = channel;
        this.retryCount = retryCount;
    }

    @Override
    public Void call() throws Exception {
        int statusCode = -1;
        Exception exp = null;
        try {
            statusCode = this.channel.doSend(this.message, this.url);
        }
        catch (Exception e) {
            exp = e;
        }
        if (statusCode == 200) {
            return null;
        }
        if (this.retryCount == 0) {
            if (exp != null) {
                fatalLog.error("send message failed.url=" + this.url + ", error=" + exp + ", message=" + this.message, (Throwable)exp);
            } else {
                fatalLog.error("send message failed.url=" + this.url + ", http status=" + statusCode + ", " + this.message);
            }
        } else {
            --this.retryCount;
            if (exp != null) {
                logger.debug("send message failed.url=" + this.url + ", remained retry=" + this.retryCount + ", error=" + exp + ", message=" + this.message, (Throwable)exp);
            } else {
                logger.debug("send message failed.url=" + this.url + ", remained retry=" + this.retryCount + ", http status=" + statusCode + ", " + this.message);
            }
            this.channel.doRetry(this);
        }
        return null;
    }
}

