/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cluster.channel.jgroups;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.iplass.mtp.impl.cluster.ClusterService;
import org.iplass.mtp.impl.cluster.Message;
import org.iplass.mtp.impl.cluster.channel.MessageChannel;
import org.iplass.mtp.impl.cluster.channel.MessageReceiver;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceInitListener;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.MessageBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsMessageChannel
implements MessageChannel,
ServiceInitListener<ClusterService> {
    private static Logger logger = LoggerFactory.getLogger(JGroupsMessageChannel.class);
    private static Logger fatalLog = LoggerFactory.getLogger((String)"mtp.fatal.cluster");
    private String configFilePath;
    private String clusterName;
    private MessageReceiver messageReceiver;
    private JChannel channel;

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Override
    public void inited(ClusterService service, Config config) {
        try (InputStream is = this.inputStreamFromFile();
             BufferedInputStream bis = new BufferedInputStream(is);){
            this.channel = new JChannel(is);
        }
        catch (Exception e) {
            throw new ServiceConfigrationException("can't read JGroups configFile:" + this.configFilePath, e);
        }
        this.channel.setReceiver((Receiver)new ReceiverAdapter(){

            public void receive(org.jgroups.Message msg) {
                if (!JGroupsMessageChannel.this.channel.getAddress().equals(msg.getSrc())) {
                    Message m = (Message)msg.getObject();
                    JGroupsMessageChannel.this.messageReceiver.receiveMessage(m);
                    if (logger.isDebugEnabled()) {
                        logger.debug("receive message:" + m);
                    }
                }
            }

            public void receive(MessageBatch batch) {
                for (org.jgroups.Message msg : batch) {
                    try {
                        this.receive(msg);
                    }
                    catch (Throwable t) {
                        logger.error("exception occurred while handling MessageBatch: " + msg + ": " + t.getMessage(), t);
                    }
                }
            }

            public void viewAccepted(View view) {
                if (logger.isDebugEnabled()) {
                    logger.debug("JGroups view changed: " + view);
                }
            }
        });
        try {
            this.channel.connect(this.clusterName);
        }
        catch (Exception e) {
            fatalLog.error("Can't connect JGroups cluster:" + this.clusterName + ", so start as standalone mode", (Throwable)e);
            this.channel = null;
        }
    }

    protected InputStream inputStreamFromFile() throws IOException {
        InputStream is = this.getClass().getResourceAsStream(this.configFilePath);
        if (is == null) {
            is = new FileInputStream(this.configFilePath);
        }
        return is;
    }

    @Override
    public void destroyed() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public void sendMessage(Message message) {
        if (this.channel != null) {
            try {
                this.channel.send(null, (Object)message);
                if (logger.isDebugEnabled()) {
                    logger.debug("send message:" + message);
                }
            }
            catch (Exception e) {
                fatalLog.error("send message failed.JGroups cluster=" + this.clusterName + ", error=" + e + ", message=" + message, (Throwable)e);
            }
        } else {
            fatalLog.warn("can't send message because JGroups cluster not initialized.JGroups cluster=" + this.clusterName + ", message=" + message);
        }
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    @Override
    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }
}

