/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command;

import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.command.InterceptorService;
import org.iplass.mtp.impl.command.InvocationImpl;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.TransactionOption;

public class CompositeCommand
implements Command {
    private Command[] commands;
    private Script executeRule;
    private Command[] proxied;

    public CompositeCommand() {
    }

    public CompositeCommand(MetaCommand.CommandRuntime[] crs, Script executeRule) {
        this.executeRule = executeRule;
        InterceptorService is = ServiceRegistry.getRegistry().getService(InterceptorService.class);
        this.commands = new Command[crs.length];
        this.proxied = new Command[crs.length];
        for (int i = 0; i < this.proxied.length; ++i) {
            this.commands[i] = crs[i].newCommand();
            this.proxied[i] = new CommandProxy(crs[i].name(), this.commands[i], crs[i].getTransactionOption(), is);
        }
    }

    public Command[] getCommands() {
        return this.commands;
    }

    @Override
    public String execute(RequestContext request) {
        if (this.executeRule == null) {
            String result = null;
            for (Command c : this.proxied) {
                result = c.execute(request);
            }
            return result;
        }
        TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
        ScriptContext sc = tc.getScriptEngine().newScriptContext();
        sc.setAttribute("cmd", this.proxied);
        sc.setAttribute("request", request);
        return (String)this.executeRule.eval(sc);
    }

    private static class CommandProxy
    implements Command {
        private String cmdName;
        private Command actual;
        private TransactionOption transactionOption;
        private InterceptorService interceptorService;

        private CommandProxy(String cmdName, Command actual, TransactionOption transactionOption, InterceptorService interceptorService) {
            this.cmdName = cmdName;
            this.actual = actual;
            this.transactionOption = transactionOption;
            this.interceptorService = interceptorService;
        }

        @Override
        public String execute(RequestContext request) {
            InvocationImpl invocation = new InvocationImpl(this.interceptorService.getInterceptors("invoker"), this.actual, request, this.transactionOption, this.cmdName);
            return invocation.proceedCommand();
        }
    }
}

