/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.async;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.iplass.mtp.async.AsyncTaskContext;
import org.iplass.mtp.async.TaskCancelException;
import org.iplass.mtp.async.TaskTimeoutException;
import org.iplass.mtp.command.CommandRuntimeException;
import org.iplass.mtp.command.async.AsyncRequestContext;
import org.iplass.mtp.command.async.ResultHandler;
import org.iplass.mtp.impl.async.ExceptionHandleable;
import org.iplass.mtp.impl.command.async.AsyncCommandService;
import org.iplass.mtp.impl.command.async.MetaAsyncCommand;
import org.iplass.mtp.spi.ServiceRegistry;

public class AsyncCommandCallable
implements Callable<Void>,
ExceptionHandleable,
Serializable {
    private static final long serialVersionUID = -6321493231703224578L;
    private final AsyncRequestContext request;
    private final String asyncTaskCmdName;
    private final ResultHandler resultHandler;
    private transient String result;

    public AsyncCommandCallable(String asyncTaskCmdName, AsyncRequestContext request, ResultHandler resultHandler) {
        this.asyncTaskCmdName = asyncTaskCmdName;
        this.request = request;
        this.resultHandler = resultHandler;
    }

    @Override
    public Void call() throws Exception {
        MetaAsyncCommand.AsyncCommandRuntime runtime = (MetaAsyncCommand.AsyncCommandRuntime)ServiceRegistry.getRegistry().getService(AsyncCommandService.class).getRuntimeByName(this.asyncTaskCmdName);
        if (runtime == null) {
            throw new CommandRuntimeException("AsyncCommand:" + this.asyncTaskCmdName + " not found");
        }
        AsyncTaskContext atc = AsyncTaskContext.getCurrentContext();
        if (atc != null) {
            this.request.setAttribute("taskId", atc.getTaskId());
            this.request.setAttribute("queue", atc.getQueueName());
        }
        this.result = runtime.executeCommand(this.request, this.resultHandler);
        return null;
    }

    public String toString() {
        return "AsyncCommand [name=" + this.asyncTaskCmdName + ", result=" + this.result + "]";
    }

    @Override
    public void aborted(Throwable cause) {
        if (this.resultHandler != null) {
            this.resultHandler.handle(cause);
        }
    }

    @Override
    public void timeouted() {
        if (this.resultHandler != null) {
            this.resultHandler.handle(new TaskTimeoutException("timeout"));
        }
    }

    @Override
    public void canceled() {
        if (this.resultHandler != null) {
            this.resultHandler.handle(new TaskCancelException("cancel"));
        }
    }
}

