/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.async;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.async.AsyncTaskManager;
import org.iplass.mtp.async.AsyncTaskOption;
import org.iplass.mtp.async.ExceptionHandlingMode;
import org.iplass.mtp.command.async.AsyncRequestContext;
import org.iplass.mtp.command.async.ResultHandler;
import org.iplass.mtp.command.async.definition.AsyncCommandDefinition;
import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.impl.command.InterceptorService;
import org.iplass.mtp.impl.command.InvocationImpl;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.command.async.AsyncCommandCallable;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;

public class MetaAsyncCommand
extends BaseRootMetaData
implements DefinableMetaData<AsyncCommandDefinition> {
    private static final long serialVersionUID = -7930313189566333668L;
    public static final String ASYNC_INTERCEPTOR_NAME = "async";
    private String queue;
    private String groupingKeyAttributeName;
    private ExceptionHandlingMode exceptionHandlingMode;
    private MetaCommand command;

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getGroupingKeyAttributeName() {
        return this.groupingKeyAttributeName;
    }

    public void setGroupingKeyAttributeName(String groupingKeyAttributeName) {
        this.groupingKeyAttributeName = groupingKeyAttributeName;
    }

    public ExceptionHandlingMode getExceptionHandlingMode() {
        return this.exceptionHandlingMode;
    }

    public void setExceptionHandlingMode(ExceptionHandlingMode exceptionHandlingMode) {
        this.exceptionHandlingMode = exceptionHandlingMode;
    }

    public MetaCommand getCommand() {
        return this.command;
    }

    public void setCommand(MetaCommand command) {
        this.command = command;
    }

    @Override
    public AsyncCommandRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new AsyncCommandRuntime();
    }

    @Override
    public MetaAsyncCommand copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(AsyncCommandDefinition definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        this.exceptionHandlingMode = definition.getExceptionHandlingMode();
        this.groupingKeyAttributeName = definition.getGroupingKeyAttributeName();
        this.queue = definition.getQueue();
        if (definition.getCommandConfig() == null) {
            this.command = null;
        } else {
            this.command = MetaCommand.createInstance(definition.getCommandConfig());
            this.command.applyConfig(definition.getCommandConfig());
        }
    }

    @Override
    public AsyncCommandDefinition currentConfig() {
        AsyncCommandDefinition def = new AsyncCommandDefinition();
        def.setName(this.name);
        def.setDisplayName(this.displayName);
        def.setDescription(this.description);
        def.setExceptionHandlingMode(this.exceptionHandlingMode);
        def.setGroupingKeyAttributeName(this.groupingKeyAttributeName);
        def.setQueue(this.queue);
        if (this.command != null) {
            def.setCommandConfig(this.command.currentConfig());
        }
        return def;
    }

    public class AsyncCommandRuntime
    extends BaseMetaDataRuntime {
        private AsyncTaskManager atm = ManagerLocator.getInstance().getManager(AsyncTaskManager.class);
        private MetaCommand.CommandRuntime cmd;
        private CommandInterceptor[] cmdInterceptors;

        public AsyncCommandRuntime() {
            try {
                if (MetaAsyncCommand.this.command != null) {
                    this.cmd = MetaAsyncCommand.this.command.createRuntime();
                }
                InterceptorService is = ServiceRegistry.getRegistry().getService(InterceptorService.class);
                this.cmdInterceptors = is.getInterceptors(MetaAsyncCommand.ASYNC_INTERCEPTOR_NAME);
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public MetaCommand.CommandRuntime getCommandRuntime() {
            return this.cmd;
        }

        @Override
        public MetaAsyncCommand getMetaData() {
            return MetaAsyncCommand.this;
        }

        public long executeAsync(AsyncRequestContext request, ResultHandler resultHandler) {
            AsyncCommandCallable task = new AsyncCommandCallable(MetaAsyncCommand.this.getName(), request, resultHandler);
            AsyncTaskOption option = new AsyncTaskOption();
            option.setQueue(MetaAsyncCommand.this.queue);
            if (MetaAsyncCommand.this.exceptionHandlingMode != null) {
                option.setExceptionHandlingMode(MetaAsyncCommand.this.exceptionHandlingMode);
            }
            if (MetaAsyncCommand.this.groupingKeyAttributeName != null) {
                option.setGroupingKey(request.getAttribute(MetaAsyncCommand.this.groupingKeyAttributeName).toString());
            }
            return this.atm.execute(option, task).getTaskId();
        }

        public String executeCommand(AsyncRequestContext req, ResultHandler resultHandler) {
            this.checkState();
            String res = new InvocationImpl(this.cmdInterceptors, this.cmd, req).proceedCommand();
            if (resultHandler != null) {
                resultHandler.handle(res);
            }
            return res;
        }
    }
}

