/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.impl.command.beanmapper.el.BeanMapperELContext;
import org.iplass.mtp.impl.command.beanmapper.el.PropertyInfo;
import org.iplass.mtp.impl.command.beanmapper.el.PropertyRef;
import org.iplass.mtp.impl.entity.EntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedListELResolver
extends ELResolver {
    private static Logger log = LoggerFactory.getLogger(ExtendedListELResolver.class);
    private static Class<?> unmodifiableListClass = Collections.unmodifiableList(new ArrayList()).getClass();

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof List) {
            Object value;
            context.setPropertyResolved(base, property);
            BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
            List list = (List)base;
            int index = this.toInt(property);
            if (this.isInvalidIndex(index, list.size(), bmc)) {
                return null;
            }
            PropertyRef pr = null;
            if (bmc.getElMapper().isAutoGrow()) {
                pr = bmc.getPropertyRef(list);
                if (index >= list.size() && (pr.getComponentTypeKind() == PropertyInfo.TypeKind.BEAN || pr.getComponentTypeKind() == PropertyInfo.TypeKind.ENTITY)) {
                    for (int i = list.size(); i <= index; ++i) {
                        list.add(null);
                    }
                }
            }
            if ((value = list.get(index)) == null && bmc.getElMapper().isAutoGrow()) {
                try {
                    switch (pr.getComponentTypeKind()) {
                        case BEAN: {
                            value = pr.getPropertyInfo().getComponentType().newInstance();
                            break;
                        }
                        case ENTITY: {
                            if (pr.getReferencePropertyHandler() != null) {
                                value = pr.getReferencePropertyHandler().getReferenceEntityHandler(EntityContext.getCurrentContext()).newInstance();
                                break;
                            }
                            if (pr.getPropertyInfo().getComponentType().isInterface()) {
                                value = new GenericEntity();
                                break;
                            }
                            value = pr.getPropertyInfo().getComponentType().newInstance();
                            break;
                        }
                        case ARRAY: 
                        case LIST: 
                        case MAP: {
                            if (log.isDebugEnabled()) {
                                log.debug("Nested collection auto grow not supported.");
                            }
                        }
                        case SIMPLE: {
                            break;
                        }
                    }
                }
                catch (ELException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ELException((Throwable)e);
                }
                if (value != null) {
                    list.set(index, value);
                }
            }
            return value;
        }
        return null;
    }

    private boolean isInvalidIndex(int index, int size, BeanMapperELContext bmc) {
        return index < 0 || !bmc.getElMapper().isAutoGrow() && index >= size || bmc.getElMapper().isAutoGrow() && index >= bmc.getElMapper().getIndexedPropertySizeLimit();
    }

    private int toInt(Object p) {
        if (p instanceof Number) {
            return ((Number)p).intValue();
        }
        if (p instanceof Character) {
            return ((Character)p).charValue();
        }
        if (p instanceof Boolean) {
            return (Boolean)p != false ? 1 : 0;
        }
        if (p instanceof String) {
            return Integer.parseInt((String)p);
        }
        throw new IllegalArgumentException();
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof List) {
            context.setPropertyResolved(true);
            BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
            List list = (List)base;
            int index = this.toInt(property);
            if (this.isInvalidIndex(index, list.size(), bmc)) {
                throw new PropertyNotFoundException();
            }
            return Object.class;
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof List) {
            context.setPropertyResolved(base, property);
            List list = (List)base;
            int index = this.toInt(property);
            try {
                BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
                if (bmc.getElMapper().isAutoGrow() && index < bmc.getElMapper().getIndexedPropertySizeLimit() && index >= list.size()) {
                    for (int i = list.size(); i <= index; ++i) {
                        list.add(null);
                    }
                }
                if (value instanceof String) {
                    if (bmc.getElMapper().isTrim()) {
                        value = ((String)value).trim();
                    }
                    if (bmc.getElMapper().isEmptyToNull() && ((String)value).isEmpty()) {
                        value = null;
                    }
                }
                list.set(index, value);
            }
            catch (UnsupportedOperationException e) {
                throw new PropertyNotWritableException();
            }
            catch (IndexOutOfBoundsException e) {
                throw new PropertyNotFoundException();
            }
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof List) {
            context.setPropertyResolved(true);
            List list = (List)base;
            int index = this.toInt(property);
            BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
            if (this.isInvalidIndex(index, list.size(), bmc)) {
                throw new PropertyNotFoundException();
            }
            return list.getClass() == unmodifiableListClass;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null && base instanceof List) {
            return Integer.class;
        }
        return null;
    }
}

