/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SelectValue;

class PropertyInfo {
    private Method readMethod;
    private Method writeMethod;
    private PropertyDescriptor descriptor;
    private TypeKind typeKind;
    private TypeKind componentTypeKind;
    private Class<?> propertyType;
    private Class<?> componentType;

    PropertyInfo(Class<?> baseClass, PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
        this.readMethod = PropertyInfo.getMethod(baseClass, descriptor.getReadMethod());
        this.writeMethod = PropertyInfo.getMethod(baseClass, descriptor.getWriteMethod());
        this.propertyType = descriptor.getPropertyType();
        this.typeKind = this.typeOf(this.propertyType);
        if (this.typeKind != null) {
            switch (this.typeKind) {
                case ARRAY: {
                    this.componentType = this.propertyType.getComponentType();
                    this.componentTypeKind = this.typeOf(this.componentType);
                    break;
                }
                case LIST: {
                    Type gt = this.readMethod.getGenericReturnType();
                    if (gt instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)gt;
                        Type t = pt.getActualTypeArguments()[0];
                        if (t instanceof Class && !Object.class.equals((Object)t)) {
                            this.componentType = (Class)t;
                        } else if (t instanceof ParameterizedType) {
                            this.componentType = ((ParameterizedType)t).getRawType().getClass();
                        }
                    }
                    this.componentTypeKind = this.typeOf(this.componentType);
                    break;
                }
                case MAP: {
                    Type gt = this.readMethod.getGenericReturnType();
                    if (gt instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)gt;
                        Type t = pt.getActualTypeArguments()[1];
                        if (t instanceof Class && !Object.class.equals((Object)t)) {
                            this.componentType = (Class)t;
                        } else if (t instanceof ParameterizedType) {
                            this.componentType = ((ParameterizedType)t).getRawType().getClass();
                        }
                    }
                    this.componentTypeKind = this.typeOf(this.componentType);
                    break;
                }
            }
        }
    }

    private TypeKind typeOf(Class<?> t) {
        if (t == null) {
            return null;
        }
        if (t.isArray()) {
            return TypeKind.ARRAY;
        }
        if (List.class.isAssignableFrom(t)) {
            return TypeKind.LIST;
        }
        if (Map.class.isAssignableFrom(t)) {
            return TypeKind.MAP;
        }
        if (Entity.class.isAssignableFrom(t)) {
            return TypeKind.ENTITY;
        }
        if (this.isSimpleType(t)) {
            return TypeKind.SIMPLE;
        }
        return TypeKind.BEAN;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public TypeKind getTypeKind() {
        return this.typeKind;
    }

    public TypeKind getComponentTypeKind() {
        return this.componentTypeKind;
    }

    private boolean isSimpleType(Class<?> propertyType) {
        if (String.class.equals(propertyType)) {
            return true;
        }
        if (propertyType.isPrimitive()) {
            return true;
        }
        if (Number.class.isAssignableFrom(propertyType)) {
            return true;
        }
        if (SelectValue.class.equals(propertyType)) {
            return true;
        }
        if (Boolean.class.equals(propertyType)) {
            return true;
        }
        if (propertyType.isEnum()) {
            return true;
        }
        if (Timestamp.class.equals(propertyType)) {
            return true;
        }
        if (Date.class.equals(propertyType)) {
            return true;
        }
        if (Time.class.equals(propertyType)) {
            return true;
        }
        if (BinaryReference.class.equals(propertyType)) {
            return true;
        }
        return Character.class.equals(propertyType);
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    public Class<?> getPropertyType() {
        return this.descriptor.getPropertyType();
    }

    public boolean isReadOnly() {
        return this.getWriteMethod() == null;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    static Method getMethod(Class<?> type, Method m) {
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i = 0; i < inf.length; ++i) {
            try {
                mp = inf[i].getMethod(m.getName(), m.getParameterTypes());
                mp = PropertyInfo.getMethod(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = PropertyInfo.getMethod(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    static enum TypeKind {
        SIMPLE,
        BEAN,
        ENTITY,
        ARRAY,
        LIST,
        MAP;

    }
}

