/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;

class SoftConcurrentHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private ConcurrentHashMap<K, SoftConcurrentHashMapValue<K, V>> map;
    private ReferenceQueue<V> refQ;

    SoftConcurrentHashMap() {
        this.map = new ConcurrentHashMap();
        this.refQ = new ReferenceQueue();
    }

    SoftConcurrentHashMap(int initialCapacity) {
        this.map = new ConcurrentHashMap(initialCapacity);
        this.refQ = new ReferenceQueue();
    }

    private void cleanup() {
        SoftConcurrentHashMapValue ref = null;
        while ((ref = (SoftConcurrentHashMapValue)this.refQ.poll()) != null) {
            this.map.remove(ref.key);
        }
    }

    @Override
    public V put(K key, V value) {
        this.cleanup();
        SoftConcurrentHashMapValue<K, V> prev = this.map.put(key, new SoftConcurrentHashMapValue<K, V>(key, value, this.refQ));
        return prev == null ? null : (V)prev.get();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.cleanup();
        SoftConcurrentHashMapValue<K, V> prev = this.map.putIfAbsent(key, new SoftConcurrentHashMapValue<K, V>(key, value, this.refQ));
        return prev == null ? null : (V)prev.get();
    }

    @Override
    public V get(Object key) {
        this.cleanup();
        SoftConcurrentHashMapValue<K, V> BPRef = this.map.get(key);
        if (BPRef == null) {
            return null;
        }
        if (BPRef.get() == null) {
            this.map.remove(key);
            return null;
        }
        return (V)BPRef.get();
    }

    private static class SoftConcurrentHashMapValue<K, V>
    extends SoftReference<V> {
        final K key;

        SoftConcurrentHashMapValue(K key, V val, ReferenceQueue<V> q) {
            super(val, q);
            this.key = key;
        }
    }
}

