/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import javax.el.ELContext;
import javax.el.TypeConverter;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.util.DateUtil;

public class TimeConverter
extends TypeConverter {
    public Object convertToType(ELContext context, Object obj, Class<?> targetType) {
        if (Time.class == targetType && obj instanceof String) {
            context.setPropertyResolved(true);
            return this.conv(obj);
        }
        return null;
    }

    private Time toTime(String exp, DateFormat sdf) {
        try {
            sdf.setLenient(false);
            return new Time(sdf.parse(exp).getTime());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private Time conv(Object obj) {
        if (obj instanceof String) {
            String exp = ((String)obj).trim();
            if ("".equals(exp)) {
                return null;
            }
            Time t = null;
            try {
                t = Time.valueOf(exp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (t == null) {
                ExecuteContext ec = ExecuteContext.getCurrentContext();
                LocaleFormat lf = ec.getLocaleFormat();
                t = this.toTime(exp, DateUtil.getSimpleDateFormat(lf.getServerTimeFormat(), false));
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getTimeInstance(2, false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat("HH:mm:ss.SSS", false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat("HHmmssSSS", false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat("HHmmss", false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat(ExecuteContext.getCurrentContext().getLocaleFormat().getOutputTimeSecFormat(), false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat(lf.getExcelTimeFormat(), true));
                }
            }
            if (t == null) {
                throw new IllegalArgumentException("Can't convert to Time:" + obj);
            }
            return t;
        }
        return null;
    }
}

