/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javax.el.ELContext;
import javax.el.TypeConverter;
import org.apache.commons.lang3.time.DateUtils;
import org.iplass.mtp.impl.command.beanmapper.el.SqlDateConverter;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.util.DateUtil;

public class TimestampConverter
extends TypeConverter {
    private SqlDateConverter dateConverter = new SqlDateConverter();

    public Object convertToType(ELContext context, Object obj, Class<?> targetType) {
        if (Timestamp.class == targetType && obj instanceof String) {
            context.setPropertyResolved(true);
            Date ts = this.conv(obj);
            if (ts == null) {
                return null;
            }
            return new Timestamp(ts.getTime());
        }
        if (Date.class == targetType && obj instanceof String) {
            context.setPropertyResolved(true);
            return this.conv(obj);
        }
        return null;
    }

    private Date toTs(String exp, DateFormat sdf) {
        try {
            sdf.setLenient(false);
            return sdf.parse(exp);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private Date conv(Object obj) {
        if (obj instanceof String) {
            String exp = ((String)obj).trim();
            if ("".equals(exp)) {
                return null;
            }
            Date t = null;
            try {
                OffsetDateTime odt = OffsetDateTime.parse(exp);
                t = new Timestamp(odt.toInstant().toEpochMilli());
            }
            catch (DateTimeParseException odt) {
                // empty catch block
            }
            if (t == null) {
                t = this.toTs(exp, new SimpleDateFormat("yyyyMMdd'T'HHmmss.SSSZ"));
            }
            if (t == null) {
                t = this.toTs(exp, new SimpleDateFormat("yyyyMMdd'T'HHmmss.SSSZ"));
            }
            if (t == null) {
                t = this.toTs(exp, new SimpleDateFormat("yyyyMMdd'T'HHmmssZ"));
            }
            if (t == null) {
                Date dt;
                ExecuteContext ec = ExecuteContext.getCurrentContext();
                LocaleFormat lf = ec.getLocaleFormat();
                t = this.toTs(exp, DateUtil.getSimpleDateFormat(lf.getServerDateTimeFormat(), true));
                if (t == null) {
                    t = this.toTs(exp, DateUtil.getDateTimeInstance(2, 2, true));
                }
                if (t == null) {
                    t = this.toTs(exp, DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", true));
                }
                if (t == null) {
                    t = this.toTs(exp, DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSXXX", false));
                }
                if (t == null) {
                    t = this.toTs(exp, DateUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss", true));
                }
                if (t == null) {
                    t = this.toTs(exp, DateUtil.getSimpleDateFormat("yyyyMMddHHmmssSSS", true));
                }
                if (t == null) {
                    t = this.toTs(exp, DateUtil.getSimpleDateFormat("yyyyMMddHHmmss", true));
                }
                if (t == null) {
                    t = this.toTs(exp, DateUtil.getSimpleDateFormat(ExecuteContext.getCurrentContext().getLocaleFormat().getOutputDatetimeSecFormat(), true));
                }
                if (t == null) {
                    t = this.toTs(exp, DateUtil.getSimpleDateFormat(lf.getExcelDateFormat() + " " + lf.getExcelTimeFormat(), true));
                }
                if (t == null && (dt = this.dateConverter.conv(exp)) != null) {
                    dt = DateUtils.truncate((Date)dt, (int)5);
                    t = new Timestamp(dt.getTime());
                }
            }
            if (t == null) {
                throw new IllegalArgumentException("Can't convert to Timestamp:" + obj);
            }
            return t;
        }
        return null;
    }
}

