/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.iplass.mtp.impl.cache.CacheController;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.LoadingAdapter;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.builtin.TransactionLocalCacheStoreFactory;
import org.iplass.mtp.impl.cluster.ClusterEventListener;
import org.iplass.mtp.impl.cluster.ClusterService;
import org.iplass.mtp.impl.cluster.Message;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.tenant.TenantService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantContextService
implements Service {
    public static final String TENANT_CONTEXT_CACHE_NAMESPACE = "mtp.tenant.tenantContext";
    private static final int CACHE_INDEX_URL = 0;
    private static final String CLUSTER_EVENT_NAME_TENANT_RELOAD = "mtp.tenant.rl";
    private static final String CLUSTER_MESSAGE_TENANT_ID = "tenantId";
    private static Logger logger = LoggerFactory.getLogger(TenantContextService.class);
    private TenantService tenantService;
    private String defaultTenantName = "";
    private String defaultPasswordPatternErrorMessage = "";
    private String defaultMailFrom = "";
    private String defaultMailFromName = "";
    private int sharedTenantId = -1;
    private List<Integer> localTenantIds;
    private CacheController<Integer, TenantContext> cache;
    private List<Class<?>> tenantResourceClasses;
    private volatile boolean destroyed = false;

    List<Class<?>> getTenantResourceClasses() {
        return this.tenantResourceClasses;
    }

    public int getSharedTenantId() {
        return this.sharedTenantId;
    }

    public List<Integer> getLocalTenantIds() {
        return this.localTenantIds;
    }

    public String getDefaultTenantName() {
        return this.defaultTenantName;
    }

    public String getPasswordPatternErrorMessage() {
        return this.defaultPasswordPatternErrorMessage;
    }

    public String getDefaultMailFrom() {
        return this.defaultMailFrom;
    }

    public String getDefaultMailFromName() {
        return this.defaultMailFromName;
    }

    public TenantContext getSharedTenantContext() {
        return this.cache.get(this.sharedTenantId);
    }

    public TenantContext getTenantContext(int tenantId) {
        return this.cache.get(tenantId);
    }

    public TenantContext getTenantContext(String url) {
        return this.cache.getByIndex(0, url);
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        CacheStore cs = this.cache.getStore();
        if (cs instanceof TransactionLocalCacheStoreFactory.TransactionLocalCacheStore) {
            cs = ((TransactionLocalCacheStoreFactory.TransactionLocalCacheStore)cs).getBackendCacheStore();
        }
        if (cs != null) {
            List<Object> keyList = cs.keySet();
            for (Object k : keyList) {
                TenantContext tc;
                CacheEntry lce = cs.get(k);
                if (lce == null || (tc = (TenantContext)lce.getValue()) == null) continue;
                tc.invalidate();
            }
        }
        ServiceRegistry.getRegistry().getService(CacheService.class).invalidate(TENANT_CONTEXT_CACHE_NAMESPACE);
    }

    @Override
    public void init(Config config) {
        this.tenantService = config.getDependentService(TenantService.class);
        if (config.getValue("sharedTenantId") != null) {
            this.sharedTenantId = Integer.parseInt(config.getValue("sharedTenantId"));
        }
        if (config.getValues("localTenantIds") != null) {
            this.localTenantIds = new ArrayList<Integer>();
            for (String ltid : config.getValues("localTenantIds")) {
                this.localTenantIds.add(Integer.parseInt(ltid));
            }
        }
        CacheService cs = config.getDependentService(CacheService.class);
        this.cache = new CacheController<Integer, TenantContext>(cs.getCache(TENANT_CONTEXT_CACHE_NAMESPACE), false, 1, new LoadingAdapter<Integer, TenantContext>(){

            @Override
            public TenantContext load(Integer key) {
                if (TenantContextService.this.destroyed) {
                    return null;
                }
                Tenant tenant = TenantContextService.this.tenantService.getTenant(key);
                if (tenant == null) {
                    if (key == TenantContextService.this.sharedTenantId) {
                        logger.debug("load and cache TenantContext as Shared Tenant:{}.", (Object)key);
                        return new TenantContext(TenantContextService.this.sharedTenantId, "_shared", null, true);
                    }
                    return null;
                }
                logger.debug("load and cache TenantContext:{}.", (Object)key);
                return new TenantContext(tenant, false);
            }

            @Override
            public List<TenantContext> loadByIndex(int indexType, Object indexVal) {
                if (TenantContextService.this.destroyed) {
                    return null;
                }
                if (indexType != 0) {
                    throw new IllegalArgumentException("not support indexType");
                }
                Tenant tenant = TenantContextService.this.tenantService.getTenant((String)indexVal);
                if (tenant == null) {
                    return null;
                }
                return Arrays.asList(new TenantContext(tenant, false));
            }

            @Override
            public long getVersion(TenantContext value) {
                return 0L;
            }

            @Override
            public Object getIndexVal(int indexType, TenantContext value) {
                if (indexType != 0) {
                    throw new IllegalArgumentException("not support indexType");
                }
                return value.getTenantUrl();
            }

            @Override
            public Integer getKey(TenantContext val) {
                return val.getTenantId();
            }
        }, false, true);
        ServiceRegistry.getRegistry().getService(ClusterService.class).registerListener(new String[]{CLUSTER_EVENT_NAME_TENANT_RELOAD}, new ClusterEventListener(){

            @Override
            public void onMessage(Message msg) {
                String tenantIdStr = msg.getParameter(TenantContextService.CLUSTER_MESSAGE_TENANT_ID);
                if (tenantIdStr != null) {
                    int tenantId = Integer.parseInt(tenantIdStr);
                    TenantContextService.this.reloadTenantContext(tenantId, true);
                }
            }
        });
        List<String> trcNames = config.getValues("tenantResource");
        if (trcNames != null) {
            this.tenantResourceClasses = new ArrayList();
            for (String trcName : trcNames) {
                try {
                    this.tenantResourceClasses.add(Class.forName(trcName));
                }
                catch (ClassNotFoundException e) {
                    throw new ServiceConfigrationException("tenantResource:" + trcName + " class not found.");
                }
            }
        }
        this.defaultTenantName = config.getValue("defaultTenantName");
        this.defaultPasswordPatternErrorMessage = config.getValue("defaultPasswordPatternErrorMessage");
        this.defaultMailFrom = config.getValue("defaultMailFrom");
        this.defaultMailFromName = config.getValue("defaultMailFromName");
    }

    public List<Integer> getAllTenantIdList() {
        if (this.localTenantIds == null) {
            return this.tenantService.getAllTenantIdList();
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.addAll(this.localTenantIds);
        if (this.sharedTenantId != -1) {
            ret.add(this.sharedTenantId);
        }
        return ret;
    }

    public List<Integer> getCurrentLoadedTenantIdList() {
        List<Object> keySet = this.cache.getStore().keySet();
        return keySet;
    }

    public void reloadTenantContext(int tenantId, boolean notifyOnlyLocal) {
        CacheEntry ce = this.cache.getStore().get(tenantId);
        if (ce != null) {
            TenantContext tc = (TenantContext)ce.getValue();
            if (tc != null) {
                tc.invalidate();
            }
            this.cache.notifyInvalid(tc);
        } else {
            this.cache.notifyInvalid(new TenantContext(tenantId));
        }
        if (tenantId == this.sharedTenantId) {
            if (this.localTenantIds != null) {
                for (Integer ltid : this.localTenantIds) {
                    CacheEntry lce = this.cache.getStore().get(ltid);
                    if (lce != null) {
                        TenantContext tc = (TenantContext)lce.getValue();
                        if (tc != null) {
                            tc.invalidate();
                        }
                        this.cache.notifyInvalid(tc);
                        continue;
                    }
                    this.cache.notifyInvalid(new TenantContext(ltid));
                }
            } else {
                List<Object> keyList = this.cache.getStore().keySet();
                for (Object k : keyList) {
                    TenantContext tc;
                    CacheEntry lce = this.cache.getStore().get(k);
                    if (lce == null || (tc = (TenantContext)lce.getValue()) == null) continue;
                    tc.invalidate();
                }
                this.cache.clearAll();
            }
        }
        if (!notifyOnlyLocal) {
            Message msg = new Message(CLUSTER_EVENT_NAME_TENANT_RELOAD);
            msg.addParameter(CLUSTER_MESSAGE_TENANT_ID, Integer.toString(tenantId));
            ServiceRegistry.getRegistry().getService(ClusterService.class).sendMessage(msg);
        }
    }
}

