/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.impl.core.config.ConfigPreprocessor;
import org.iplass.mtp.impl.core.config.DefaultPropertyValueCoder;
import org.iplass.mtp.impl.core.config.FileUtil;
import org.iplass.mtp.impl.core.config.NameValue;
import org.iplass.mtp.impl.core.config.PropertyValueCoder;
import org.iplass.mtp.impl.core.config.ServiceConfig;
import org.iplass.mtp.impl.core.config.ServiceDefinition;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodePreprocessor
implements ConfigPreprocessor {
    private static Logger logger = LoggerFactory.getLogger(DecodePreprocessor.class);
    private PropertyValueCoder coder;

    public DecodePreprocessor() {
        String cryptConfigFileName = BootstrapProps.getInstance().getProperty("mtp.config.crypt");
        if (cryptConfigFileName != null) {
            this.coder = this.getPropertyValueCoder(cryptConfigFileName);
        }
    }

    @Override
    public ServiceDefinition preprocess(ServiceDefinition serviceDefinition) {
        if (this.coder != null && serviceDefinition.getService() != null) {
            for (ServiceConfig sc : serviceDefinition.getService()) {
                this.decode(sc, this.coder);
            }
        }
        return serviceDefinition;
    }

    private void decode(ServiceConfig sc, PropertyValueCoder coder) {
        if (sc.getProperty() != null) {
            for (NameValue p : sc.getProperty()) {
                this.decode(p, coder);
            }
        }
    }

    public void decode(NameValue nv, PropertyValueCoder coder) {
        if (nv.isEncrypted()) {
            if (nv.getValue() != null) {
                nv.setValue(coder.decode(nv.getValue()));
            }
            if (nv.getTextValue() != null) {
                nv.setTextValue(coder.decode(nv.getTextValue()));
            }
        }
        if (nv.getProperty() != null) {
            for (NameValue p : nv.getProperty()) {
                this.decode(p, coder);
            }
        }
        if (nv.getArg() != null) {
            for (NameValue p : nv.getArg()) {
                this.decode(p, coder);
            }
        }
    }

    private PropertyValueCoder getPropertyValueCoder(String fileName) {
        Properties prop = new Properties();
        try {
            String content = FileUtil.readContent(fileName);
            if (content == null) {
                logger.error("CryptConfigFile:" + fileName + " not found.Can not initialize ServiceRegistry.");
                throw new ServiceConfigrationException("Config File:" + fileName + " Not Found.");
            }
            prop.load(new StringReader(content));
        }
        catch (IOException e) {
            throw new ServiceConfigrationException("can not load CryptConfigFile", e);
        }
        try {
            String propertyValueCoderName = prop.getProperty("propertyValueCoder", DefaultPropertyValueCoder.class.getName());
            PropertyValueCoder coder = (PropertyValueCoder)Class.forName(propertyValueCoderName).newInstance();
            coder.open(prop);
            return coder;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ServiceConfigrationException(e);
        }
    }
}

