/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.util.Arrays;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.iplass.mtp.impl.core.config.NameValue;

public class ServiceConfig {
    private String name;
    private String interfaceName;
    private String className;
    private String[] depend;
    private NameValue[] property;
    private NameValue[] bean;
    private boolean isFinal;
    private boolean isInherit = true;
    private boolean isIfnone = false;

    @XmlAttribute
    public boolean isIfnone() {
        return this.isIfnone;
    }

    public void setIfnone(boolean isIfnone) {
        this.isIfnone = isIfnone;
    }

    @XmlAttribute
    public boolean isInherit() {
        return this.isInherit;
    }

    public void setInherit(boolean isInherit) {
        this.isInherit = isInherit;
    }

    @XmlAttribute
    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NameValue[] getProperty() {
        return this.property;
    }

    public void setProperty(NameValue[] property) {
        this.property = property;
    }

    public NameValue[] getBean() {
        return this.bean;
    }

    public void setBean(NameValue[] bean) {
        this.bean = bean;
    }

    @XmlElement(name="interface")
    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @XmlElement(name="class")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String[] getDepend() {
        return this.depend;
    }

    public void setDepend(String[] depend) {
        this.depend = depend;
    }

    public String id() {
        if (this.name != null) {
            return this.name;
        }
        if (this.interfaceName == null) {
            throw new NullPointerException("can not determine ServiceConfig's id. name or interface must specified.name=" + this.name + ",interfaceName=" + this.interfaceName + ",className=" + this.className);
        }
        return this.interfaceName;
    }

    public ServiceConfig merge(ServiceConfig superConfig) {
        ServiceConfig merged = new ServiceConfig();
        merged.interfaceName = superConfig.interfaceName;
        merged.name = superConfig.name;
        merged.isFinal = this.isFinal;
        merged.isIfnone = this.isIfnone;
        merged.className = this.className != null ? this.className : superConfig.className;
        if (this.depend != null) {
            TreeSet<String> set = new TreeSet<String>();
            if (superConfig.depend != null) {
                set.addAll(Arrays.asList(superConfig.depend));
            }
            set.addAll(Arrays.asList(this.depend));
            merged.depend = set.toArray(new String[set.size()]);
        } else {
            merged.depend = superConfig.depend;
        }
        merged.property = NameValue.mergeNameValueArray(this.id(), this.property, superConfig.property);
        merged.bean = NameValue.mergeNameValueArray(this.id() + "(bean)", this.bean, superConfig.bean);
        return merged;
    }
}

