/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore;

import net.logstash.logback.argument.StructuredArguments;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.Refer;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.Or;
import org.iplass.mtp.entity.query.condition.predicate.Contains;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.hint.SuppressWarningsHint;
import org.iplass.mtp.entity.query.value.RowValueList;
import org.iplass.mtp.entity.query.value.aggregate.Avg;
import org.iplass.mtp.entity.query.value.aggregate.Count;
import org.iplass.mtp.entity.query.value.aggregate.Listagg;
import org.iplass.mtp.entity.query.value.aggregate.Max;
import org.iplass.mtp.entity.query.value.aggregate.Median;
import org.iplass.mtp.entity.query.value.aggregate.Min;
import org.iplass.mtp.entity.query.value.aggregate.Mode;
import org.iplass.mtp.entity.query.value.aggregate.StdDevPop;
import org.iplass.mtp.entity.query.value.aggregate.StdDevSamp;
import org.iplass.mtp.entity.query.value.aggregate.Sum;
import org.iplass.mtp.entity.query.value.aggregate.VarPop;
import org.iplass.mtp.entity.query.value.aggregate.VarSamp;
import org.iplass.mtp.entity.query.value.controlflow.Case;
import org.iplass.mtp.entity.query.value.expr.MinusSign;
import org.iplass.mtp.entity.query.value.expr.Polynomial;
import org.iplass.mtp.entity.query.value.expr.Term;
import org.iplass.mtp.entity.query.value.primary.ArrayValue;
import org.iplass.mtp.entity.query.value.primary.Cast;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.ParenValue;
import org.iplass.mtp.entity.query.value.subquery.ScalarSubQuery;
import org.iplass.mtp.entity.query.value.window.CumeDist;
import org.iplass.mtp.entity.query.value.window.DenseRank;
import org.iplass.mtp.entity.query.value.window.PercentRank;
import org.iplass.mtp.entity.query.value.window.Rank;
import org.iplass.mtp.entity.query.value.window.RowNumber;
import org.iplass.mtp.entity.query.value.window.WindowAggregate;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.rdb.connection.AdditionalWarnLogInfo;

public class EQLAdditionalWarnLogInfo
implements AdditionalWarnLogInfo {
    private static final int NO_INDEX_FLAG = 1;
    private static final int WEAK_INDEX_FLAG = 2;
    private static final int CORRELATED_SUBQUERY_CONDITION_FLAG = 4;
    private static final String[] ALERT_MESSAGE = new String[]{null, "!WITHOUT INDEX QUERY!", "!LOW CARDINALITY INDEX QUERY!", "!WITHOUT INDEX QUERY!", "!CORRELATED SUBQUERY IN CONDITION QUERY!", "!WITHOUT INDEX QUERY! !CORRELATED SUBQUERY IN CONDITION QUERY!", "!LOW CARDINALITY INDEX QUERY! !CORRELATED SUBQUERY IN CONDITION QUERY!", "!WITHOUT INDEX QUERY! !CORRELATED SUBQUERY IN CONDITION QUERY!"};
    private static final String EQL_TYPE_EQL = "eql";
    private static final String EQL_TYPE_COUNT = "eql(count)";
    private final Query query;
    private final boolean count;
    private EntityHandler eh;
    private EntityContext ec;
    private boolean checked;
    private boolean doLog;
    private int alertFlags = 0;

    public EQLAdditionalWarnLogInfo(Query query, boolean count, EntityHandler eh, EntityContext ec) {
        this.query = query;
        this.count = count;
        this.eh = eh;
        this.ec = ec;
    }

    @Override
    public String toString() {
        if (this.doLog) {
            StringBuilder sb = new StringBuilder();
            String msg = ALERT_MESSAGE[this.alertFlags];
            if (msg != null) {
                sb.append(msg).append(' ');
            }
            if (this.count) {
                sb.append("eql(count)=");
            } else {
                sb.append("eql=");
            }
            sb.append(this.query);
            return sb.toString();
        }
        if (this.count) {
            return "eql(count)=" + this.query;
        }
        return "eql=" + this.query;
    }

    @Override
    public String logFormat() {
        if (this.doLog) {
            return "{} {}={}";
        }
        return "{}={}";
    }

    @Override
    public int parameterSize() {
        if (this.doLog) {
            return 3;
        }
        return 2;
    }

    @Override
    public void setParameter(int offset, Object[] params) {
        if (this.doLog) {
            params[offset] = StructuredArguments.value((String)"alert_message", (Object)ALERT_MESSAGE[this.alertFlags]);
            params[offset + 1] = this.count ? StructuredArguments.value((String)"eql_type", (Object)EQL_TYPE_COUNT) : StructuredArguments.value((String)"eql_type", (Object)EQL_TYPE_EQL);
            params[offset + 2] = StructuredArguments.value((String)EQL_TYPE_EQL, (Object)this.query.toString());
        } else {
            params[offset] = this.count ? StructuredArguments.value((String)"eql_type", (Object)EQL_TYPE_COUNT) : StructuredArguments.value((String)"eql_type", (Object)EQL_TYPE_EQL);
            params[offset + 1] = StructuredArguments.value((String)EQL_TYPE_EQL, (Object)this.query.toString());
        }
    }

    @Override
    public boolean logBefore() {
        if (!this.checked) {
            CheckWarning checkWarning = new CheckWarning(this.eh, this.ec);
            checkWarning.check(this.query);
            if (checkWarning.suppressWarnings) {
                this.doLog = false;
            } else {
                SubQueryCheckWarning subQueryCheckWarning = new SubQueryCheckWarning(this.ec);
                subQueryCheckWarning.check(this.query);
                if (!checkWarning.index || !subQueryCheckWarning.index) {
                    this.alertFlags |= 1;
                }
                if (!checkWarning.highCardinality || !subQueryCheckWarning.highCardinality) {
                    this.alertFlags |= 2;
                }
                if (checkWarning.correlatedSubqueryCondition || subQueryCheckWarning.correlatedSubqueryCondition) {
                    this.alertFlags |= 4;
                }
                this.doLog = this.alertFlags > 0;
            }
            this.checked = true;
        }
        return this.doLog;
    }

    private static class CheckWarning
    extends QueryVisitorSupport {
        private EntityHandler eh;
        private EntityContext ec;
        private boolean index;
        private boolean highCardinality;
        private boolean suppressWarnings;
        private boolean correlatedSubqueryCondition;
        private boolean enableRef;

        CheckWarning(EntityHandler eh, EntityContext ec) {
            this.eh = eh;
            this.ec = ec;
        }

        void check(Query q) {
            this.index = false;
            this.highCardinality = false;
            this.suppressWarnings = false;
            this.enableRef = false;
            q.accept(this);
        }

        void checkOn(Condition on) {
            this.enableRef = true;
            on.accept(this);
        }

        @Override
        public boolean visit(SuppressWarningsHint suppressWarningsHint) {
            this.suppressWarnings = true;
            return super.visit(suppressWarningsHint);
        }

        @Override
        public boolean visit(Query query) {
            if (query.getSelect().getHintComment() != null) {
                query.getSelect().getHintComment().accept(this);
                if (this.suppressWarnings) {
                    return false;
                }
            }
            if (query.getRefer() != null) {
                for (Refer r : query.getRefer()) {
                    r.accept(this);
                }
            }
            if (query.getWhere() != null) {
                query.getWhere().accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(Like like) {
            if (like.getPattern() == null) {
                return false;
            }
            if (like.getPattern().startsWith("%")) {
                return false;
            }
            if (like.getPattern().startsWith("_")) {
                return false;
            }
            return super.visit(like);
        }

        @Override
        public boolean visit(Or or) {
            if (or.getChildExpressions() != null) {
                boolean hc = true;
                for (Condition c : or.getChildExpressions()) {
                    this.index = false;
                    this.highCardinality = false;
                    c.accept(this);
                    if (!this.index) {
                        return false;
                    }
                    hc &= this.highCardinality;
                }
                this.highCardinality = hc;
            }
            return false;
        }

        @Override
        public boolean visit(IsNotNull isNotNull) {
            return false;
        }

        @Override
        public boolean visit(IsNull isNull) {
            return false;
        }

        @Override
        public boolean visit(EntityField entityField) {
            GRdbPropertyStoreRuntime psr;
            if (entityField.unnestCount() > 0) {
                return false;
            }
            if (this.enableRef && entityField.getPropertyName().equalsIgnoreCase("this")) {
                this.index = true;
                this.highCardinality = true;
                return false;
            }
            PropertyHandler ph = this.eh.getPropertyCascade(entityField.getPropertyName(), this.ec);
            if (ph == null) {
                return false;
            }
            if (ph instanceof ReferencePropertyHandler) {
                if (this.enableRef) {
                    this.index = true;
                    this.highCardinality = true;
                    return false;
                }
                return false;
            }
            if (ph.isIndexed()) {
                this.index = true;
                if (ph.getEnumType() != PropertyDefinitionType.BOOLEAN && ph.getEnumType() != PropertyDefinitionType.SELECT) {
                    this.highCardinality = true;
                }
            } else if (ph.getName().equals("oid") || ph.getName().equals("createBy")) {
                this.index = true;
                this.highCardinality = true;
            } else if (ph.getStoreSpecProperty() instanceof GRdbPropertyStoreRuntime && (psr = (GRdbPropertyStoreRuntime)((Object)ph.getStoreSpecProperty())).isNative() && ph.getParent().getSuperDataModelHandler(this.ec) != null) {
                this.index = true;
                this.highCardinality = true;
            }
            return false;
        }

        @Override
        public boolean visit(Count count) {
            return false;
        }

        @Override
        public boolean visit(Sum sum) {
            return false;
        }

        @Override
        public boolean visit(Polynomial polynomial) {
            return false;
        }

        @Override
        public boolean visit(Term term) {
            return false;
        }

        @Override
        public boolean visit(ParenValue parenthesizedValue) {
            return super.visit(parenthesizedValue);
        }

        @Override
        public boolean visit(MinusSign minusSign) {
            return false;
        }

        @Override
        public boolean visit(ScalarSubQuery scalarSubQuery) {
            this.correlatedSubqueryCondition = true;
            return false;
        }

        @Override
        public boolean visit(SubQuery subQuery) {
            return false;
        }

        @Override
        public boolean visit(Avg avg) {
            return false;
        }

        @Override
        public boolean visit(Max max) {
            return false;
        }

        @Override
        public boolean visit(Min min) {
            return false;
        }

        @Override
        public boolean visit(ArrayValue arrayValue) {
            return false;
        }

        @Override
        public boolean visit(Function function) {
            return false;
        }

        @Override
        public boolean visit(Cast cast) {
            return false;
        }

        @Override
        public boolean visit(Refer refer) {
            if (refer.getCondition() != null) {
                refer.getCondition().accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(Contains contains) {
            return false;
        }

        @Override
        public boolean visit(Case caseClause) {
            return false;
        }

        @Override
        public boolean visit(StdDevPop stdDevPop) {
            return false;
        }

        @Override
        public boolean visit(StdDevSamp stdDevSamp) {
            return false;
        }

        @Override
        public boolean visit(VarPop varPop) {
            return false;
        }

        @Override
        public boolean visit(VarSamp varSamp) {
            return false;
        }

        @Override
        public boolean visit(Mode mode) {
            return false;
        }

        @Override
        public boolean visit(Median median) {
            return false;
        }

        @Override
        public boolean visit(Listagg listagg) {
            return false;
        }

        @Override
        public boolean visit(WindowAggregate windowAggregate) {
            return false;
        }

        @Override
        public boolean visit(RowNumber rowNumber) {
            return false;
        }

        @Override
        public boolean visit(Rank rank) {
            return false;
        }

        @Override
        public boolean visit(DenseRank denseRank) {
            return false;
        }

        @Override
        public boolean visit(PercentRank percentRank) {
            return false;
        }

        @Override
        public boolean visit(CumeDist cumeDist) {
            return false;
        }

        @Override
        public boolean visit(RowValueList rowValueList) {
            return false;
        }
    }

    private static class SubQueryCheckWarning
    extends QueryVisitorSupport {
        private EntityContext ec;
        private boolean index = true;
        private boolean highCardinality = true;
        private boolean correlatedSubqueryCondition = false;

        SubQueryCheckWarning(EntityContext ec) {
            this.ec = ec;
        }

        @Override
        public boolean visit(SubQuery subQuery) {
            if (subQuery.getQuery() != null) {
                CheckWarning sub = new CheckWarning(this.ec.getHandlerByName(subQuery.getQuery().getFrom().getEntityName()), this.ec);
                sub.check(subQuery.getQuery());
                if (subQuery.getOn() != null) {
                    sub.checkOn(subQuery.getOn());
                }
                this.index &= sub.index;
                this.highCardinality &= sub.highCardinality;
                this.correlatedSubqueryCondition |= sub.correlatedSubqueryCondition;
                if (!this.index) {
                    return false;
                }
            }
            return false;
        }

        void check(Query q) {
            q.accept(this);
        }
    }
}

