/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.query.value.RowValueList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.aggregate.Avg;
import org.iplass.mtp.entity.query.value.aggregate.Count;
import org.iplass.mtp.entity.query.value.aggregate.Listagg;
import org.iplass.mtp.entity.query.value.aggregate.Max;
import org.iplass.mtp.entity.query.value.aggregate.Median;
import org.iplass.mtp.entity.query.value.aggregate.Min;
import org.iplass.mtp.entity.query.value.aggregate.Mode;
import org.iplass.mtp.entity.query.value.aggregate.StdDevPop;
import org.iplass.mtp.entity.query.value.aggregate.StdDevSamp;
import org.iplass.mtp.entity.query.value.aggregate.Sum;
import org.iplass.mtp.entity.query.value.aggregate.VarPop;
import org.iplass.mtp.entity.query.value.aggregate.VarSamp;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroup;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroupSortSpec;
import org.iplass.mtp.entity.query.value.controlflow.Case;
import org.iplass.mtp.entity.query.value.controlflow.Else;
import org.iplass.mtp.entity.query.value.controlflow.When;
import org.iplass.mtp.entity.query.value.expr.MinusSign;
import org.iplass.mtp.entity.query.value.expr.Polynomial;
import org.iplass.mtp.entity.query.value.expr.Term;
import org.iplass.mtp.entity.query.value.primary.ArrayValue;
import org.iplass.mtp.entity.query.value.primary.Cast;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.entity.query.value.primary.ParenValue;
import org.iplass.mtp.entity.query.value.subquery.ScalarSubQuery;
import org.iplass.mtp.entity.query.value.window.CumeDist;
import org.iplass.mtp.entity.query.value.window.DenseRank;
import org.iplass.mtp.entity.query.value.window.PartitionBy;
import org.iplass.mtp.entity.query.value.window.PercentRank;
import org.iplass.mtp.entity.query.value.window.Rank;
import org.iplass.mtp.entity.query.value.window.RowNumber;
import org.iplass.mtp.entity.query.value.window.WindowAggregate;
import org.iplass.mtp.entity.query.value.window.WindowOrderBy;
import org.iplass.mtp.entity.query.value.window.WindowSortSpec;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyService;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.properties.basic.DecimalType;
import org.iplass.mtp.impl.properties.basic.FloatType;
import org.iplass.mtp.impl.properties.basic.IntegerType;
import org.iplass.mtp.impl.properties.basic.StringType;
import org.iplass.mtp.impl.properties.extend.ExpressionType;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;
import org.iplass.mtp.spi.ServiceRegistry;

public class RdbBaseValueTypeResolver
implements ValueExpressionVisitor,
FunctionAdapter.ArgumentTypeResolver {
    private EntityHandler fromEntity;
    private EntityContext context;
    private PropertyService propService;
    private RdbAdapter rdb;
    private PropertyType type;

    public RdbBaseValueTypeResolver(EntityHandler fromEntity, EntityContext context, RdbAdapter rdb) {
        this.fromEntity = fromEntity;
        this.context = context;
        this.rdb = rdb;
        this.propService = ServiceRegistry.getRegistry().getService(PropertyService.class);
    }

    public PropertyType resolve(ValueExpression val) {
        this.type = null;
        val.accept(this);
        return this.type;
    }

    @Override
    public Class<?> resolveType(ValueExpression value) {
        this.type = null;
        value.accept(this);
        if (this.type == null) {
            return null;
        }
        return this.type.storeType();
    }

    @Override
    public boolean visit(Literal literal) {
        this.type = literal.getValue() == null ? null : this.propService.getPropertyType(literal.getValue().getClass());
        return false;
    }

    @Override
    public boolean visit(EntityField entityField) {
        PropertyHandler ph = this.fromEntity.getPropertyCascade(entityField.getPropertyName(), this.context);
        if (ph instanceof PrimitivePropertyHandler) {
            this.type = ((MetaPrimitiveProperty)ph.getMetaData()).getType();
            if (this.type instanceof ExpressionType) {
                PropertyDefinitionType et = ((ExpressionType)this.type).getResultType();
                this.type = et == null ? this.propService.getPropertyType(String.class) : this.propService.getPropertyType(et);
            }
        } else {
            this.type = null;
        }
        return false;
    }

    @Override
    public boolean visit(Polynomial polynomial) {
        ArrayList<PropertyType> subTypeList = new ArrayList<PropertyType>();
        this.getSubTypeList(subTypeList, polynomial.getAddValues());
        this.getSubTypeList(subTypeList, polynomial.getSubValues());
        this.type = this.whichType(subTypeList);
        return false;
    }

    private void getSubTypeList(List<PropertyType> list, List<ValueExpression> subList) {
        if (subList != null) {
            for (ValueExpression v : subList) {
                v.accept(this);
                list.add(this.type);
            }
        }
    }

    private PropertyType whichType(List<PropertyType> type) {
        if (type == null || type.size() == 0) {
            return null;
        }
        PropertyType res = null;
        for (int i = 0; i < type.size(); ++i) {
            PropertyType c = type.get(i);
            if (c instanceof FloatType) {
                return c;
            }
            if (c instanceof DecimalType) {
                res = c;
                continue;
            }
            if (c instanceof IntegerType) {
                if (res instanceof DecimalType) continue;
                res = c;
                continue;
            }
            if (c instanceof StringType) {
                if (res instanceof DecimalType || res instanceof IntegerType) continue;
                res = c;
                continue;
            }
            if (res instanceof DecimalType || res instanceof IntegerType || res instanceof StringType) continue;
            res = c;
        }
        return res;
    }

    @Override
    public boolean visit(Term term) {
        ArrayList<PropertyType> subTypeList = new ArrayList<PropertyType>();
        this.getSubTypeList(subTypeList, term.getMulValues());
        this.getSubTypeList(subTypeList, term.getDivValues());
        this.type = this.whichType(subTypeList);
        return false;
    }

    @Override
    public boolean visit(ParenValue bracketValue) {
        bracketValue.getNestedValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(MinusSign minusSign) {
        minusSign.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(ScalarSubQuery scalarSubQuery) {
        EntityHandler subEntity = this.context.getHandlerByName(scalarSubQuery.getQuery().getFrom().getEntityName());
        RdbBaseValueTypeResolver subResolver = new RdbBaseValueTypeResolver(subEntity, this.context, this.rdb);
        this.type = subResolver.resolve(scalarSubQuery.getQuery().getSelect().getSelectValues().get(0));
        return false;
    }

    @Override
    public boolean visit(Count count) {
        this.type = this.propService.getPropertyType(Long.class);
        return false;
    }

    @Override
    public boolean visit(Sum sum) {
        sum.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(Avg avg) {
        this.type = this.propService.getPropertyType(Double.class);
        return false;
    }

    @Override
    public boolean visit(Max max) {
        max.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(Min min) {
        min.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(StdDevPop stdDevPop) {
        this.type = this.propService.getPropertyType(Double.class);
        return false;
    }

    @Override
    public boolean visit(StdDevSamp stdDevSamp) {
        this.type = this.propService.getPropertyType(Double.class);
        return false;
    }

    @Override
    public boolean visit(VarPop varPop) {
        this.type = this.propService.getPropertyType(Double.class);
        return false;
    }

    @Override
    public boolean visit(VarSamp varSamp) {
        this.type = this.propService.getPropertyType(Double.class);
        return false;
    }

    @Override
    public boolean visit(Mode mode) {
        mode.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(Median median) {
        median.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(Listagg listagg) {
        this.type = this.propService.getPropertyType(String.class);
        return false;
    }

    @Override
    public boolean visit(WithinGroup withinGroup) {
        return false;
    }

    @Override
    public boolean visit(WithinGroupSortSpec sortSpec) {
        return false;
    }

    @Override
    public boolean visit(ArrayValue arrayValue) {
        ArrayList<PropertyType> subTypeList = new ArrayList<PropertyType>();
        this.getSubTypeList(subTypeList, arrayValue.getValues());
        this.type = this.whichType(subTypeList);
        return false;
    }

    @Override
    public boolean visit(Function function) {
        FunctionAdapter<Function> fa = this.rdb.resolveFunction(function.getName());
        if (fa != null) {
            Class<?> funcType = fa.getType(function, this);
            this.type = this.propService.getPropertyType(funcType);
        }
        return false;
    }

    @Override
    public boolean visit(Case caseClause) {
        for (When w : caseClause.getWhen()) {
            w.accept(this);
            if (this.type == null) continue;
            break;
        }
        if (this.type == null && caseClause.getElseClause() != null) {
            caseClause.getElseClause().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(Else elseClause) {
        elseClause.getResult().accept(this);
        return false;
    }

    @Override
    public boolean visit(When when) {
        when.getResult().accept(this);
        return false;
    }

    @Override
    public boolean visit(Cast cast) {
        this.type = cast.getType() == PropertyDefinitionType.DECIMAL && cast.getTypeArgument(0) != null ? new DecimalType(cast.getTypeArgument(0), RoundingMode.HALF_EVEN) : this.propService.getPropertyType(cast.getType());
        return false;
    }

    @Override
    public boolean visit(WindowAggregate windowAggregate) {
        windowAggregate.getAggregate().accept(this);
        return false;
    }

    @Override
    public boolean visit(RowNumber rowNumber) {
        this.type = this.propService.getPropertyType(Long.class);
        return false;
    }

    @Override
    public boolean visit(Rank rank) {
        this.type = this.propService.getPropertyType(Long.class);
        return false;
    }

    @Override
    public boolean visit(DenseRank denseRank) {
        this.type = this.propService.getPropertyType(Long.class);
        return false;
    }

    @Override
    public boolean visit(PercentRank percentRank) {
        this.type = this.propService.getPropertyType(Double.class);
        return false;
    }

    @Override
    public boolean visit(CumeDist cumeDist) {
        this.type = this.propService.getPropertyType(Double.class);
        return false;
    }

    @Override
    public boolean visit(PartitionBy partitionBy) {
        return false;
    }

    @Override
    public boolean visit(WindowOrderBy orderBy) {
        return false;
    }

    @Override
    public boolean visit(WindowSortSpec sortSpec) {
        return false;
    }

    @Override
    public boolean visit(RowValueList rowValueList) {
        return false;
    }
}

