/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql;

import java.util.List;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class IndexDeleteSql
extends UpdateSqlHandler {
    private static final String TMP_TABLE_ALIAS = "tt";

    public String deleteByColName(int tenantId, String defId, String tableNamePostfix, int pageNo, String colName, BaseRdbTypeAdapter typeAdapter, IndexType type, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(MetaGRdbEntityStore.makeIndexTableName(typeAdapter.getColOfIndex(), tableNamePostfix));
        } else {
            sb.append(MetaGRdbEntityStore.makeUniqueIndexTableName(typeAdapter.getColOfIndex(), tableNamePostfix));
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(defId));
        sb.append("' AND COL_NAME='").append(rdb.sanitize(MetaGRdbPropertyStore.makeExternalIndexColName(pageNo, colName))).append("'");
        return sb.toString();
    }

    public String toSqlDelByOid(int tenantId, EntityHandler eh, String colOfIndex, IndexType type, String oid, Long version, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colOfIndex));
        } else {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colOfIndex));
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId()));
        sb.append("' AND OBJ_ID='").append(rdb.sanitize(oid)).append("'");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(" AND OBJ_VER=");
            if (version != null) {
                sb.append(version);
            } else {
                sb.append("0");
            }
        }
        return sb.toString();
    }

    public String deleteByTempTable(int tenantId, EntityHandler eh, String colOfIndex, IndexType type, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colOfIndex));
        } else {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colOfIndex));
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId())).append("'");
        if (type == IndexType.NON_UNIQUE) {
            if (rdb.isSupportRowValueConstructor()) {
                sb.append(" AND (OBJ_ID,OBJ_VER) IN(SELECT OBJ_ID,OBJ_VER FROM " + rdb.getTemplaryTablePrefix() + "OBJ_STORE_TMP" + ")");
            } else {
                String objIndexTable = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colOfIndex);
                sb.append(" AND EXISTS (SELECT 1 FROM ").append(rdb.getTemplaryTablePrefix() + "OBJ_STORE_TMP").append(" ").append(TMP_TABLE_ALIAS);
                sb.append(" WHERE ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_ID").append("=").append(objIndexTable).append(".").append("OBJ_ID");
                sb.append(" AND ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_VER").append("=").append(objIndexTable).append(".").append("OBJ_VER");
                sb.append(")");
            }
        } else {
            sb.append(" AND OBJ_ID IN(SELECT OBJ_ID FROM " + rdb.getTemplaryTablePrefix() + "OBJ_STORE_TMP" + ")");
        }
        return sb.toString();
    }

    public String deleteByOidAndVersion(int tenantId, MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef, String oid, Long version, RdbAdapter rdb) {
        EntityHandler eh = colDef.getPropertyRuntime().getParent();
        String objDefId = eh.getMetaData().getId();
        String colName = colDef.getExternalIndexColName();
        IndexType type = colDef.getPropertyRuntime().getMetaData().getIndexType();
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()));
        } else {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()));
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(objDefId));
        sb.append("' AND COL_NAME='").append(rdb.sanitize(colName));
        sb.append("' AND OBJ_ID='").append(rdb.sanitize(oid)).append("'");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(" AND OBJ_VER=");
            if (version != null) {
                sb.append(version);
            } else {
                sb.append("0");
            }
        }
        return sb.toString();
    }

    public String deleteAll(int tenantId, String defId, String tableNamePostfix, String colTypePostFix, IndexType type, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(MetaGRdbEntityStore.makeIndexTableName(colTypePostFix, tableNamePostfix));
        } else {
            sb.append(MetaGRdbEntityStore.makeUniqueIndexTableName(colTypePostFix, tableNamePostfix));
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(defId)).append("'");
        return sb.toString();
    }

    public String deleteForDefrag(int tenantId, EntityHandler eh, String colTypePostFix, IndexType type, List<String> usedColNames, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        if (type == IndexType.NON_UNIQUE) {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_INDEX(colTypePostFix));
        } else {
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_UNIQUE(colTypePostFix));
        }
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId())).append("'");
        if (usedColNames != null && usedColNames.size() > 0) {
            sb.append(" AND COL_NAME NOT IN (");
            for (int i = 0; i < usedColNames.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("'").append(rdb.sanitize(usedColNames.get(i))).append("'");
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

