/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql.queryconvert;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.sql.ToSqlResult;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlQueryContext;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.TableAliasMapping;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;

public class JoinPath {
    public static String PAGE_PREFIX = "p";
    private static String OUTER_JOIN = "LEFT OUTER JOIN";
    private static String INNER_JOIN = "INNER JOIN";
    private TableAliasMapping aliases;
    String name;
    boolean isUse;
    boolean isMappedBy;
    private boolean isRoot;
    String refDefId;
    String taregtObjDefId;
    String mappedByObjDefId;
    String myAlias;
    String objRefTableName;
    String objDataTableName;
    int refTenantId;
    int dataTenantId;
    private boolean joinWithVersionCol;
    private boolean joinRefWithDataTable;
    private String additionalCondition;
    private List<ToSqlResult.BindValue> bindVariables;
    JoinPath parent;
    ArrayList<JoinPath> children;
    HashSet<Integer> pageNo;

    public JoinPath(TableAliasMapping aliases, EntityContext context) {
        this(aliases, false, null, context);
    }

    public JoinPath(TableAliasMapping aliases, boolean isRoot, EntityHandler rootEh, EntityContext context) {
        this.aliases = aliases;
        this.isRoot = isRoot;
        if (isRoot) {
            this.myAlias = aliases.getAlias(null);
            this.objDataTableName = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)rootEh.getEntityStoreRuntime()).OBJ_STORE();
            this.taregtObjDefId = rootEh.getMetaData().getId();
            this.dataTenantId = context.getTenantId(rootEh);
        }
        this.joinWithVersionCol = true;
    }

    public void merge(JoinPath another) {
        this.isUse = this.isUse || another.isUse;
        this.joinWithVersionCol = this.joinWithVersionCol || another.joinWithVersionCol;
        boolean bl = this.joinRefWithDataTable = this.joinRefWithDataTable || another.joinRefWithDataTable;
        if (another.children != null) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            for (JoinPath ac : another.children) {
                boolean find = false;
                for (JoinPath c : this.children) {
                    if (!c.name.equals(ac.name)) continue;
                    find = true;
                    c.merge(ac);
                    break;
                }
                if (find) continue;
                this.children.add(ac);
            }
        }
    }

    public JoinPath getJoinPath(String path) {
        if (this.children == null) {
            return null;
        }
        int dotIndex = path.indexOf(46);
        if (dotIndex > -1) {
            String childName = path.substring(0, dotIndex);
            for (JoinPath c : this.children) {
                if (!c.name.equals(childName)) continue;
                return c.getJoinPath(path.substring(dotIndex + 1));
            }
        } else {
            for (JoinPath c : this.children) {
                if (!c.name.equals(path)) continue;
                return c;
            }
        }
        return null;
    }

    private void checkVersionPropertyUsed(String propName, EntityHandler eh) {
        if (this.joinWithVersionCol && eh.isVersioned()) {
            switch (propName) {
                case "version": 
                case "state": 
                case "startDate": 
                case "endDate": {
                    this.joinWithVersionCol = false;
                    break;
                }
            }
        }
    }

    private void addPageNo(int pn) {
        if (this.pageNo == null) {
            this.pageNo = new HashSet();
        }
        this.pageNo.add(pn);
    }

    private void checkPageNo(String propName, EntityHandler eh, boolean useIndex) {
        GRdbPropertyStoreRuntime col;
        PropertyHandler ph = eh.getDeclaredProperty(propName);
        if (ph != null && ph instanceof PrimitivePropertyHandler && (col = (GRdbPropertyStoreRuntime)((Object)ph.getStoreSpecProperty())) != null && !col.isNative()) {
            for (MetaGRdbPropertyStore.GRdbPropertyStoreHandler scol : col.asList()) {
                if (!useIndex || col.isMulti() || scol.getIndexColName() == null) {
                    if (scol.getMetaData().getPageNo() <= 0) continue;
                    this.addPageNo(scol.getMetaData().getPageNo());
                    continue;
                }
                if (scol.getMetaData().getIndexPageNo() <= 0) continue;
                this.addPageNo(scol.getMetaData().getIndexPageNo());
            }
        }
    }

    public void addPath(String[] propPath, int currentPos, EntityContext context, EntityHandler dataModelHandler, boolean onCondition, boolean useIndex) {
        if (propPath.length == currentPos + 2) {
            this.isUse = true;
            if (onCondition) {
                this.checkVersionPropertyUsed(propPath[currentPos + 1], dataModelHandler);
            }
            this.checkPageNo(propPath[currentPos + 1], dataModelHandler, useIndex);
        }
        if (propPath.length > currentPos + 2) {
            ReferencePropertyHandler pHandler;
            if (this.children == null) {
                this.children = new ArrayList();
            }
            JoinPath matched = null;
            for (JoinPath j : this.children) {
                if (!j.name.equals(propPath[currentPos + 1])) continue;
                matched = j;
                break;
            }
            if ((pHandler = (ReferencePropertyHandler)dataModelHandler.getDeclaredProperty(propPath[currentPos + 1])) == null) {
                throw new NullPointerException(dataModelHandler.getMetaData().getName() + "." + propPath[currentPos + 1] + " not found");
            }
            if (matched == null) {
                matched = new JoinPath(this.aliases, context);
                matched.name = propPath[currentPos + 1];
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i <= currentPos + 1; ++i) {
                    if (i != 0) {
                        sb.append(".");
                    }
                    sb.append(propPath[i]);
                }
                matched.myAlias = this.aliases.getAlias(sb.toString());
                matched.parent = this;
                ReferencePropertyHandler mappedBy = pHandler.getMappedByPropertyHandler(context);
                EntityHandler refEh = pHandler.getReferenceEntityHandler(context);
                matched.taregtObjDefId = refEh.getMetaData().getId();
                boolean bl = matched.isMappedBy = mappedBy != null;
                if (matched.isMappedBy) {
                    matched.refDefId = mappedBy.getId();
                    matched.mappedByObjDefId = refEh.getMetaData().getId();
                    matched.objRefTableName = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)refEh.getEntityStoreRuntime()).OBJ_REF();
                    matched.refTenantId = context.getTenantId(refEh);
                } else {
                    matched.refDefId = pHandler.getId();
                    matched.objRefTableName = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)dataModelHandler.getEntityStoreRuntime()).OBJ_REF();
                    matched.refTenantId = context.getTenantId(dataModelHandler);
                }
                if (dataModelHandler.isVersioned() && !matched.isMappedBy) {
                    matched.joinRefWithDataTable = true;
                    this.isUse = true;
                }
                matched.objDataTableName = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)refEh.getEntityStoreRuntime()).OBJ_STORE();
                matched.dataTenantId = context.getTenantId(refEh);
                this.children.add(matched);
            }
            matched.addPath(propPath, currentPos + 1, context, pHandler.getReferenceEntityHandler(context), onCondition, useIndex);
        }
    }

    public void setAdditionalCondition(String additionalCondition, List<ToSqlResult.BindValue> bindVariables) {
        this.additionalCondition = additionalCondition;
        this.bindVariables = bindVariables;
    }

    public List<ToSqlResult.BindValue> getOrderedBindVariables() {
        if (this.children == null) {
            return this.bindVariables;
        }
        ArrayList<ToSqlResult.BindValue> ret = null;
        if (this.bindVariables != null) {
            ret = new ArrayList<ToSqlResult.BindValue>();
            ret.addAll(this.bindVariables);
        }
        for (JoinPath c : this.children) {
            List<ToSqlResult.BindValue> cblist = c.getOrderedBindVariables();
            if (cblist == null) continue;
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.addAll(cblist);
        }
        if (ret != null && ret.size() > 0) {
            return ret;
        }
        return null;
    }

    public void appendJoinCause(StringBuilder sb, SqlQueryContext sqc) {
        if (!this.isRoot) {
            sb.append(" ").append(OUTER_JOIN).append(" ");
            sb.append(this.objRefTableName);
            sb.append(" ");
            this.appendPath(sb);
            sb.append("_r ");
            if (sqc.getRdb().isSupportTableHint()) {
                sqc.appendTableHint(this.myAlias + "_r", sb);
            }
            sb.append("ON ");
            this.appendRefTablePrefix(this, sb);
            sb.append("TENANT_ID=");
            sb.append(this.refTenantId);
            if (this.isMappedBy) {
                sb.append(" AND ");
                this.appendRefTablePrefix(this, sb);
                sb.append("OBJ_DEF_ID='");
                sb.append(this.taregtObjDefId);
                sb.append("' AND ");
                this.appendRefTablePrefix(this, sb);
                sb.append("TARGET_OBJ_DEF_ID='");
                sb.append(this.parent.taregtObjDefId);
                sb.append("'");
            } else {
                sb.append(" AND ");
                this.appendRefTablePrefix(this, sb);
                sb.append("OBJ_DEF_ID='");
                sb.append(this.parent.taregtObjDefId);
                sb.append("' AND ");
                this.appendRefTablePrefix(this, sb);
                sb.append("TARGET_OBJ_DEF_ID='");
                sb.append(this.taregtObjDefId);
                sb.append("'");
            }
            sb.append(" AND ");
            if (this.joinRefWithDataTable) {
                this.appendDataColEquals("OBJ_ID", "TARGET_OBJ_ID", sb);
                sb.append(" AND ");
                this.appendDataColEquals("OBJ_VER", "TARGET_OBJ_VER", sb);
            } else {
                this.appendRefColEquals("OBJ_ID", "TARGET_OBJ_ID", sb);
                sb.append(" AND ");
                this.appendRefColEquals("OBJ_VER", "TARGET_OBJ_VER", sb);
            }
            sb.append(" AND ");
            this.appendRefTablePrefix(this, sb);
            sb.append("REF_DEF_ID='");
            sb.append(this.refDefId);
            sb.append("'");
            if (this.isUse) {
                sb.append(" ").append(OUTER_JOIN).append(" ");
                sb.append(this.objDataTableName);
                sb.append(" ");
                this.appendPath(sb);
                sb.append(" ");
                if (sqc.getRdb().isSupportTableHint()) {
                    sqc.appendTableHint(this.myAlias, sb);
                }
                sb.append("ON ");
                this.appendPath(sb);
                sb.append(".TENANT_ID=");
                sb.append(this.dataTenantId);
                sb.append(" AND ");
                this.appendPath(sb);
                sb.append(".OBJ_DEF_ID='");
                sb.append(this.taregtObjDefId);
                sb.append("'");
                sb.append(" AND ");
                this.appendRefTablePrefix(this, sb);
                if (this.isMappedBy) {
                    sb.append("OBJ_ID");
                } else {
                    sb.append("TARGET_OBJ_ID");
                }
                sb.append("=");
                this.appendPath(sb);
                sb.append(".OBJ_ID");
                if (this.isRoot || this.joinWithVersionCol || this.isMappedBy) {
                    sb.append(" AND ");
                    this.appendRefTablePrefix(this, sb);
                    if (this.isMappedBy) {
                        sb.append("OBJ_VER");
                    } else {
                        sb.append("TARGET_OBJ_VER");
                    }
                    sb.append("=");
                    this.appendPath(sb);
                    sb.append(".OBJ_VER");
                }
                sb.append(" AND ");
                this.appendPath(sb);
                sb.append(".PG_NO=0");
                if (this.additionalCondition != null) {
                    sb.append(" AND (");
                    sb.append(this.additionalCondition);
                    sb.append(")");
                }
            }
        }
        if (this.pageNo != null && this.pageNo.size() > 0) {
            for (Integer pn : this.pageNo) {
                sb.append(" ");
                if (this.isRoot) {
                    sb.append(INNER_JOIN);
                } else {
                    sb.append(OUTER_JOIN);
                }
                sb.append(" ");
                sb.append(this.objDataTableName).append(" ");
                this.appendPath(sb);
                sb.append(PAGE_PREFIX).append(pn);
                sb.append(" ");
                if (sqc.getRdb().isSupportTableHint()) {
                    sqc.appendTableHint(this.myAlias + PAGE_PREFIX + pn, sb);
                }
                sb.append("ON ");
                this.appendPath(sb);
                sb.append(PAGE_PREFIX).append(pn);
                sb.append(".").append("TENANT_ID");
                sb.append("=");
                sb.append(this.dataTenantId);
                sb.append(" AND ");
                this.appendPath(sb);
                sb.append(PAGE_PREFIX).append(pn);
                sb.append(".").append("OBJ_DEF_ID");
                sb.append("=");
                sb.append("'").append(this.taregtObjDefId).append("'");
                sb.append(" AND ");
                this.appendPath(sb);
                sb.append(".").append("OBJ_ID");
                sb.append("=");
                this.appendPath(sb);
                sb.append(PAGE_PREFIX).append(pn);
                sb.append(".").append("OBJ_ID");
                sb.append(" AND ");
                this.appendPath(sb);
                sb.append(".").append("OBJ_VER");
                sb.append("=");
                this.appendPath(sb);
                sb.append(PAGE_PREFIX).append(pn);
                sb.append(".").append("OBJ_VER");
                sb.append(" AND ");
                this.appendPath(sb);
                sb.append(PAGE_PREFIX).append(pn);
                sb.append(".").append("PG_NO");
                sb.append("=").append(pn);
            }
        }
        if (this.children != null) {
            for (JoinPath c : this.children) {
                c.appendJoinCause(sb, sqc);
            }
        }
    }

    private void appendRefColEquals(String ownerColName, String targetColName, StringBuilder sb) {
        this.appendRefTablePrefix(this.parent, sb);
        if (this.parent.isRoot) {
            sb.append(ownerColName);
        } else if (this.parent.isMappedBy) {
            sb.append(ownerColName);
        } else {
            sb.append(targetColName);
        }
        sb.append("=");
        this.appendRefTablePrefix(this, sb);
        if (this.isMappedBy) {
            sb.append(targetColName);
        } else {
            sb.append(ownerColName);
        }
    }

    private void appendDataColEquals(String ownerColName, String targetColName, StringBuilder sb) {
        if (this.parent.isRoot) {
            sb.append(this.aliases.getAlias(null)).append(".");
        } else {
            this.parent.appendPath(sb);
            sb.append(".");
        }
        sb.append(ownerColName);
        sb.append("=");
        this.appendRefTablePrefix(this, sb);
        if (this.isMappedBy) {
            sb.append(targetColName);
        } else {
            sb.append(ownerColName);
        }
    }

    private void appendRefTablePrefix(JoinPath table, StringBuilder sb) {
        if (table.isRoot) {
            sb.append(this.aliases.getAlias(null)).append(".");
        } else {
            table.appendPath(sb);
            sb.append("_r.");
        }
    }

    private void appendPath(StringBuilder sb) {
        sb.append(this.myAlias);
    }
}

