/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql.queryconvert;

import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;

class MultiPageChecker
extends QueryVisitorSupport {
    private EntityHandler eh;
    private EntityContext ec;
    private String targetRef;
    private boolean multiPage = false;
    private boolean allPropertyUnderRef = true;

    MultiPageChecker(EntityHandler eh, EntityContext ec, String targetRef) {
        this.eh = eh;
        this.ec = ec;
        this.targetRef = targetRef + ".";
    }

    boolean isMultiPage() {
        return this.multiPage;
    }

    public boolean isAllPropertyUnderRef() {
        return this.allPropertyUnderRef;
    }

    @Override
    public boolean visit(EntityField entityField) {
        PropertyHandler ph;
        if (!this.multiPage && entityField.getPropertyName().startsWith(this.targetRef) && (ph = this.eh.getPropertyCascade(entityField.getPropertyName(), this.ec)) != null && ph instanceof PrimitivePropertyHandler) {
            PrimitivePropertyHandler pph = (PrimitivePropertyHandler)ph;
            GRdbPropertyStoreRuntime psr = (GRdbPropertyStoreRuntime)((Object)pph.getStoreSpecProperty());
            for (MetaGRdbPropertyStore.GRdbPropertyStoreHandler gpsh : psr.asList()) {
                if (gpsh.getMetaData().getPageNo() > 0) {
                    this.multiPage = true;
                }
                if (!(psr.isNative() || psr.isMulti() || gpsh.isExternalIndex() || gpsh.getIndexColName() == null || gpsh.getMetaData().getIndexPageNo() <= 0)) {
                    this.multiPage = true;
                }
                if (!this.multiPage) continue;
                break;
            }
        }
        if (!entityField.getPropertyName().startsWith(this.targetRef)) {
            this.allPropertyUnderRef = false;
        }
        return true;
    }

    @Override
    public boolean visit(SubQuery scalarSubQuery) {
        return false;
    }
}

