/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.impl.datastore.grdb.GRdbDataStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreMaintenanceSql;
import org.iplass.mtp.impl.datastore.grdb.sql.SchemaControlHandleLockSql;
import org.iplass.mtp.impl.datastore.grdb.sql.SchemaControlInsertSql;
import org.iplass.mtp.impl.datastore.grdb.sql.SchemaControlSearchSql;
import org.iplass.mtp.impl.datastore.grdb.sql.SchemaControlUpdateVersionSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColContext;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColResolver;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.LockStatus;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.UpdEntity;
import org.iplass.mtp.impl.datastore.strategy.ApplyMetaDataStrategy;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaSchemalessRdbStoreMapping;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class GRdbApplyMetaDataStrategy
implements ApplyMetaDataStrategy {
    private GRdbDataStore dataStore;
    private RdbAdapter rdb;
    private SchemaControlInsertSql scInsSql;
    private SchemaControlHandleLockSql schlSql;
    private SchemaControlUpdateVersionSql scuvSql;
    private SchemaControlSearchSql scSearchSql;

    public GRdbApplyMetaDataStrategy(GRdbDataStore dataStore, RdbAdapter rdb) {
        this.dataStore = dataStore;
        this.rdb = rdb;
        this.scInsSql = rdb.getUpdateSqlCreator(SchemaControlInsertSql.class);
        this.schlSql = rdb.getUpdateSqlCreator(SchemaControlHandleLockSql.class);
        this.scuvSql = rdb.getUpdateSqlCreator(SchemaControlUpdateVersionSql.class);
        this.scSearchSql = rdb.getQuerySqlCreator(SchemaControlSearchSql.class);
    }

    @Override
    public void create(final MetaEntity newOne, final EntityContext context) {
        MetaSchemalessRdbStoreMapping mapping = (MetaSchemalessRdbStoreMapping)newOne.getStoreMapping();
        StorageSpaceMap ssMap = this.dataStore.getStorageSpaceMapOrDefault(mapping);
        ColResolver colResolver = new ColResolver(null, mapping, ssMap, this.rdb);
        MetaGRdbEntityStore ssDef = colResolver.getMetaStore();
        newOne.setEntityStoreDefinition(ssDef);
        ssDef.setVersion(0);
        ssDef.setTableNamePostfix(ssMap.generateTableNamePostfix(context.getLocalTenantId(), newOne.getId()));
        for (MetaProperty prop : newOne.getDeclaredPropertyList()) {
            if (!(prop instanceof MetaPrimitiveProperty)) continue;
            colResolver.allocateCol((MetaPrimitiveProperty)prop, null, newOne.getVersionControlType());
        }
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                int currentVer = -1;
                try (ResultSet rs = this.getStatement().executeQuery(GRdbApplyMetaDataStrategy.this.scSearchSql.toSql(context.getLocalTenantId(), newOne.getId(), false, GRdbApplyMetaDataStrategy.this.rdb));){
                    currentVer = GRdbApplyMetaDataStrategy.this.scSearchSql.getCurrentVersion(rs);
                }
                int count = 0;
                if (currentVer >= 0) {
                    String sql = GRdbApplyMetaDataStrategy.this.scuvSql.toSql(context.getLocalTenantId(), newOne.getId(), currentVer, 0, true, LockStatus.NO_LOCK, GRdbApplyMetaDataStrategy.this.rdb);
                    count = this.getStatement().executeUpdate(sql);
                } else {
                    String sql = GRdbApplyMetaDataStrategy.this.scInsSql.toSql(context.getLocalTenantId(), newOne.getId(), 0, GRdbApplyMetaDataStrategy.this.rdb);
                    count = this.getStatement().executeUpdate(sql);
                }
                return count > 0;
            }
        };
        exec.execute(this.rdb, true);
    }

    @Override
    public boolean isLocked(final MetaEntity definition, final EntityContext context) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                boolean locked = false;
                try (ResultSet rs = this.getStatement().executeQuery(GRdbApplyMetaDataStrategy.this.scSearchSql.toSql(context.getLocalTenantId(), definition.getId(), false, GRdbApplyMetaDataStrategy.this.rdb));){
                    locked = GRdbApplyMetaDataStrategy.this.scSearchSql.isLocked(rs);
                }
                return locked;
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }

    @Override
    public boolean prepare(MetaEntity newOne, final MetaEntity previous, final EntityContext context) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean logic() throws SQLException {
                int currentVer = ((MetaGRdbEntityStore)previous.getEntityStoreDefinition()).getVersion();
                boolean needIns = false;
                try (ResultSet rs = this.getStatement().executeQuery(GRdbApplyMetaDataStrategy.this.scSearchSql.toSql(context.getLocalTenantId(), previous.getId(), true, GRdbApplyMetaDataStrategy.this.rdb));){
                    if (!rs.next()) {
                        needIns = true;
                    }
                }
                if (needIns) {
                    String insSql = GRdbApplyMetaDataStrategy.this.scInsSql.toSql(context.getLocalTenantId(), previous.getId(), currentVer, GRdbApplyMetaDataStrategy.this.rdb);
                    this.getStatement().executeUpdate(insSql);
                }
                String sql = GRdbApplyMetaDataStrategy.this.schlSql.toSql(context.getLocalTenantId(), previous.getId(), currentVer, LockStatus.NO_LOCK, LockStatus.LOCK, GRdbApplyMetaDataStrategy.this.rdb);
                int count = this.getStatement().executeUpdate(sql);
                return count > 0;
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }

    @Override
    public boolean modify(final MetaEntity newOne, final MetaEntity previous, final EntityContext context, final int[] targetTenantIds) {
        final UpdEntity updateDiff = new UpdEntity(previous, newOne, context, this.dataStore.getStorageSpaceMapOrDefault((MetaSchemalessRdbStoreMapping)previous.getStoreMapping()), this.dataStore.getStorageSpaceMapOrDefault((MetaSchemalessRdbStoreMapping)newOne.getStoreMapping()), this.rdb, this.dataStore.isForceRegenerateTableNamePostfix());
        updateDiff.modifyMetaData();
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                for (int tenantId : targetTenantIds) {
                    updateDiff.applyToData(this.getStatement(), GRdbApplyMetaDataStrategy.this.rdb, tenantId);
                }
                int currentVer = ((MetaGRdbEntityStore)previous.getEntityStoreDefinition()).getVersion();
                int newVer = ((MetaGRdbEntityStore)newOne.getEntityStoreDefinition()).getVersion();
                String sql = GRdbApplyMetaDataStrategy.this.scuvSql.toSql(context.getLocalTenantId(), newOne.getId(), currentVer, newVer, updateDiff.needDataModify(), LockStatus.LOCK, GRdbApplyMetaDataStrategy.this.rdb);
                int count = this.getStatement().executeUpdate(sql);
                return count > 0;
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }

    @Override
    public void patchData(MetaEntity newOne, MetaEntity previous, EntityContext context, final int targetTenantId) {
        final UpdEntity updateDiff = new UpdEntity(previous, newOne, context, this.dataStore.getStorageSpaceMapOrDefault((MetaSchemalessRdbStoreMapping)previous.getStoreMapping()), this.dataStore.getStorageSpaceMapOrDefault((MetaSchemalessRdbStoreMapping)newOne.getStoreMapping()), this.rdb);
        if (updateDiff.needDataModify()) {
            updateDiff.modifyMetaData();
            SqlExecuter<Void> exec = new SqlExecuter<Void>(){

                @Override
                public Void logic() throws SQLException {
                    updateDiff.applyToData(this.getStatement(), GRdbApplyMetaDataStrategy.this.rdb, targetTenantId);
                    return null;
                }
            };
            exec.execute(this.rdb, true);
        }
    }

    @Override
    public void finish(boolean modifyResult, MetaEntity newOne, MetaEntity previous, final EntityContext context) {
        int ver;
        final MetaEntity toEnt = modifyResult ? newOne : previous;
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(ver = ((MetaGRdbEntityStore)toEnt.getEntityStoreDefinition()).getVersion()){
            final /* synthetic */ int val$ver;
            {
                this.val$ver = n;
            }

            @Override
            public Boolean logic() throws SQLException {
                String sql = GRdbApplyMetaDataStrategy.this.schlSql.toSql(context.getLocalTenantId(), toEnt.getId(), this.val$ver, LockStatus.LOCK, LockStatus.NO_LOCK, GRdbApplyMetaDataStrategy.this.rdb);
                int count = this.getStatement().executeUpdate(sql);
                return count > 0;
            }
        };
        Boolean res = (Boolean)exec.execute(this.rdb, true);
        if (!res.booleanValue()) {
            throw new EntityRuntimeException("fail unlock Entity:" + previous.getName() + "(tenant=" + context.getLocalTenantId() + ",id=" + toEnt.getId() + ",version=" + ver + ",modifyResult=" + modifyResult + ")");
        }
    }

    @Override
    public boolean defrag(final MetaEntity target, final EntityContext context, final int[] targetTenantIds) {
        SqlExecuter<Boolean> exec = new SqlExecuter<Boolean>(){

            @Override
            public Boolean logic() throws SQLException {
                MetaSchemalessRdbStoreMapping mapping = (MetaSchemalessRdbStoreMapping)target.getStoreMapping();
                StorageSpaceMap ssMap = GRdbApplyMetaDataStrategy.this.dataStore.getStorageSpaceMapOrDefault(mapping);
                int currentVer = ((MetaGRdbEntityStore)target.getEntityStoreDefinition()).getVersion();
                int currentPageNo = ((MetaGRdbEntityStore)target.getEntityStoreDefinition()).currentMaxPage();
                ColResolver colResolver = new ColResolver(target, (MetaSchemalessRdbStoreMapping)target.getStoreMapping(), ssMap, GRdbApplyMetaDataStrategy.this.rdb);
                colResolver.shrink();
                if (!colResolver.getColContext().hasColCopy()) {
                    return true;
                }
                int newVer = currentVer + 1;
                colResolver.getMetaStore().setVersion(newVer);
                target.setEntityStoreDefinition(colResolver.getMetaStore());
                int newPageNo = colResolver.getMetaStore().currentMaxPage();
                for (int tenantId : targetTenantIds) {
                    ObjStoreMaintenanceSql sc = GRdbApplyMetaDataStrategy.this.rdb.getUpdateSqlCreator(ObjStoreMaintenanceSql.class);
                    switch (GRdbApplyMetaDataStrategy.this.rdb.getMultiTableUpdateMethod()) {
                        case INLINE_VIEW: 
                        case NO_SUPPORT: {
                            List<ColContext.ColCopy> ccl = colResolver.getColContext().getColCopyList(0);
                            this.getStatement().executeUpdate(sc.updateCol(tenantId, target.getId(), colResolver.getMetaStore().getVersion(), 0, ccl, colResolver.getMetaStore().getTableNamePostfix(), GRdbApplyMetaDataStrategy.this.rdb));
                            this.getStatement().executeUpdate(sc.updateColRB(tenantId, target.getId(), colResolver.getMetaStore().getVersion(), 0, ccl, colResolver.getMetaStore().getTableNamePostfix(), GRdbApplyMetaDataStrategy.this.rdb));
                            for (int i = 1; i <= newPageNo; ++i) {
                                ccl = colResolver.getColContext().getColCopyList(i);
                                if (ccl == null) continue;
                                this.getStatement().executeUpdate(sc.updateCol(tenantId, target.getId(), colResolver.getMetaStore().getVersion(), i, ccl, colResolver.getMetaStore().getTableNamePostfix(), GRdbApplyMetaDataStrategy.this.rdb));
                                this.getStatement().executeUpdate(sc.updateColRB(tenantId, target.getId(), colResolver.getMetaStore().getVersion(), i, ccl, colResolver.getMetaStore().getTableNamePostfix(), GRdbApplyMetaDataStrategy.this.rdb));
                            }
                            break;
                        }
                        case DIRECT_JOIN: {
                            List[] ccls = new List[newPageNo + 1];
                            for (int i = 0; i <= newPageNo; ++i) {
                                ccls[i] = colResolver.getColContext().getColCopyList(i);
                            }
                            this.getStatement().executeUpdate(sc.updateColDirectJoin(tenantId, target.getId(), colResolver.getMetaStore().getVersion(), ccls, colResolver.getMetaStore().getTableNamePostfix(), GRdbApplyMetaDataStrategy.this.rdb));
                            this.getStatement().executeUpdate(sc.updateColDirectJoinRB(tenantId, target.getId(), colResolver.getMetaStore().getVersion(), ccls, colResolver.getMetaStore().getTableNamePostfix(), GRdbApplyMetaDataStrategy.this.rdb));
                            break;
                        }
                    }
                    if (newPageNo >= currentPageNo) continue;
                    this.getStatement().executeUpdate(sc.deletePage(tenantId, target.getId(), newPageNo + 1, currentPageNo, colResolver.getMetaStore().getTableNamePostfix(), GRdbApplyMetaDataStrategy.this.rdb));
                    this.getStatement().executeUpdate(sc.deletePageRB(tenantId, target.getId(), newPageNo + 1, currentPageNo, colResolver.getMetaStore().getTableNamePostfix(), GRdbApplyMetaDataStrategy.this.rdb));
                }
                String sql = GRdbApplyMetaDataStrategy.this.scuvSql.toSql(context.getLocalTenantId(), target.getId(), currentVer, newVer, true, LockStatus.LOCK, GRdbApplyMetaDataStrategy.this.rdb);
                int count = this.getStatement().executeUpdate(sql);
                return count > 0;
            }
        };
        return (Boolean)exec.execute(this.rdb, true);
    }
}

